/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(role=EquinoxLifecycleListener.class, hint="MavenURLStreamHandlerService")
public class MavenURLStreamHandlerService
extends AbstractURLStreamHandlerService
implements EquinoxLifecycleListener {
    private static final String PROTOCOL = "mvn";
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport context;
    @Requirement
    private RepositorySystem repositorySystem;
    private MavenSession mavenSession;

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        this.mavenSession = this.context.getSession();
        framework.registerService(URLStreamHandlerService.class, (Object)this, Map.of("url.handler.protocol", new String[]{PROTOCOL}));
    }

    public URLConnection openConnection(URL url) throws IOException {
        MavenSession session = this.context.getSession();
        if (session == null) {
            this.logger.warn("Called connect() outside maven thread, using global session, project specific repositories or configuration might be ignored!");
            session = this.mavenSession;
        }
        return new MavenURLConnection(url, session, this.repositorySystem, this.logger);
    }

    private static final class MavenURLConnection
    extends URLConnection {
        private String subPath;
        private Artifact artifact;
        private Logger logger;
        private MavenSession mavenSession;
        private RepositorySystem repositorySystem;

        protected MavenURLConnection(URL url, MavenSession mavenSession, RepositorySystem repositorySystem, Logger logger) {
            super(url);
            this.mavenSession = mavenSession;
            this.repositorySystem = repositorySystem;
            this.logger = logger;
        }

        @Override
        public void connect() throws IOException {
            try {
                Object[] coordinates;
                if (this.artifact != null) {
                    return;
                }
                String path = this.url.getPath();
                if (path == null) {
                    throw new IOException("maven coordinates are missing");
                }
                int subPathIndex = path.indexOf(47);
                if (subPathIndex > -1) {
                    this.subPath = path.substring(subPathIndex);
                    coordinates = path.substring(0, subPathIndex).split(":");
                } else {
                    coordinates = path.split(":");
                }
                if (coordinates.length < 3) {
                    throw new IOException("required format is groupId:artifactId:version[:packaging[:classifier]]");
                }
                String type = coordinates.length > 3 ? coordinates[3] : "jar";
                String classifier = coordinates.length > 4 ? coordinates[4] : null;
                String groupId = coordinates[0];
                String artifactId = coordinates[1];
                String version = coordinates[2];
                this.artifact = classifier != null && !classifier.isEmpty() ? this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, type, classifier) : this.repositorySystem.createArtifact(groupId, artifactId, version, null, type);
                this.logger.debug("Resolve " + this.artifact + "...");
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setArtifact(this.artifact);
                request.setResolveRoot(true);
                request.setOffline(this.mavenSession.isOffline());
                request.setLocalRepository(this.mavenSession.getLocalRepository());
                request.setResolveTransitively(false);
                request.setRemoteRepositories(this.mavenSession.getCurrentProject().getRemoteArtifactRepositories());
                ArtifactResolutionResult result = this.repositorySystem.resolve(request);
                if (result.hasExceptions()) {
                    String message = "resolving " + this.artifact + " failed!";
                    List exceptions = result.getExceptions();
                    if (exceptions.size() == 1) {
                        throw new IOException(message, (Throwable)exceptions.get(0));
                    }
                    IOException exception = new IOException(message);
                    for (Exception suppressed : exceptions) {
                        exception.addSuppressed(suppressed);
                    }
                    throw exception;
                }
                Set artifacts = result.getArtifacts();
                if (artifacts.isEmpty()) {
                    throw new IOException("artifact " + Arrays.toString(coordinates) + " could not be retrieved from any of the available repositories");
                }
                if (artifacts.size() > 1) {
                    throw new IOException("artifact " + Arrays.toString(coordinates) + " resolves to multiple artifacts");
                }
                this.artifact = (Artifact)artifacts.iterator().next();
            }
            catch (RuntimeException e) {
                throw new IOException("internal error connecting to maven url " + this.url, e);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            File location = this.artifact.getFile();
            if (this.subPath == null) {
                return new FileInputStream(location);
            }
            String urlSpec = "jar:" + location.toURI() + "!" + this.subPath;
            return new URL(urlSpec).openStream();
        }

        @Override
        public long getLastModified() {
            try {
                this.connect();
            }
            catch (IOException e) {
                return 0L;
            }
            return this.artifact.getFile().lastModified();
        }
    }
}

