/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.Constants;
import org.apache.maven.surefire.api.booter.MasterProcessCommand;
import org.apache.maven.surefire.api.booter.Shutdown;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.stream.AbstractStreamDecoder;
import org.apache.maven.surefire.api.stream.MalformedChannelException;
import org.apache.maven.surefire.api.stream.SegmentType;
import org.apache.maven.surefire.shared.utils.cli.ShutdownHookUtils;

public class CommandDecoder
extends AbstractStreamDecoder<Command, MasterProcessCommand, SegmentType> {
    private static final int DEBUG_SINK_BUFFER_SIZE = 65536;
    private static final int NO_POSITION = -1;
    private static final SegmentType[] COMMAND_WITHOUT_DATA = new SegmentType[]{SegmentType.END_OF_FRAME};
    private static final SegmentType[] COMMAND_WITH_ONE_STRING = new SegmentType[]{SegmentType.STRING_ENCODING, SegmentType.DATA_STRING, SegmentType.END_OF_FRAME};
    private final ForkNodeArguments arguments;
    private final OutputStream debugSink;

    public CommandDecoder(@Nonnull ReadableByteChannel channel, @Nonnull ForkNodeArguments arguments) {
        super(channel, arguments, MasterProcessCommand.COMMAND_TYPES);
        this.arguments = arguments;
        this.debugSink = this.newDebugSink();
    }

    @Override
    public Command decode(@Nonnull AbstractStreamDecoder.Memento memento) throws IOException, MalformedChannelException {
        try {
            MasterProcessCommand commandType = (MasterProcessCommand)((Object)this.readMessageType(memento));
            if (commandType == null) {
                throw new AbstractStreamDecoder.MalformedFrameException(memento.getLine().getPositionByteBuffer(), memento.getByteBuffer().position());
            }
            block16: for (SegmentType segmentType : this.nextSegmentType(commandType)) {
                switch (segmentType) {
                    case STRING_ENCODING: {
                        memento.setCharset(this.readCharset(memento));
                        continue block16;
                    }
                    case DATA_STRING: {
                        memento.getData().add(this.readString(memento));
                        continue block16;
                    }
                    case DATA_INTEGER: {
                        memento.getData().add(this.readInteger(memento));
                        continue block16;
                    }
                    case END_OF_FRAME: {
                        memento.getLine().setPositionByteBuffer(memento.getByteBuffer().position());
                        memento.getLine().clear();
                        Command command = this.toMessage(commandType, memento);
                        return command;
                    }
                    default: {
                        memento.getLine().setPositionByteBuffer(-1);
                        this.arguments.dumpStreamText("Unknown enum (" + SegmentType.class.getSimpleName() + ") " + (Object)((Object)segmentType));
                    }
                }
            }
        }
        catch (AbstractStreamDecoder.MalformedFrameException e) {
            if (e.hasValidPositions()) {
                int length = e.readTo() - e.readFrom();
                memento.getLine().write(memento.getByteBuffer(), e.readFrom(), length);
            }
            Command command = null;
            return command;
        }
        catch (RuntimeException e) {
            this.getArguments().dumpStreamException(e);
            SegmentType[] segmentTypeArray = null;
            return segmentTypeArray;
        }
        catch (IOException e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                this.printRemainingStream(memento);
            }
            throw e;
        }
        finally {
            memento.reset();
        }
        throw new MalformedChannelException();
    }

    @Override
    @Nonnull
    protected final byte[] getEncodedMagicNumber() {
        return Constants.MAGIC_NUMBER_FOR_COMMANDS_BYTES;
    }

    @Nonnull
    protected SegmentType[] nextSegmentType(@Nonnull MasterProcessCommand commandType) {
        switch (commandType) {
            case NOOP: 
            case BYE_ACK: 
            case SKIP_SINCE_NEXT_TEST: 
            case TEST_SET_FINISHED: {
                return COMMAND_WITHOUT_DATA;
            }
            case RUN_CLASS: 
            case SHUTDOWN: {
                return COMMAND_WITH_ONE_STRING;
            }
        }
        throw new IllegalArgumentException("Unknown enum " + (Object)((Object)commandType));
    }

    @Override
    @Nonnull
    protected Command toMessage(@Nonnull MasterProcessCommand commandType, @Nonnull AbstractStreamDecoder.Memento memento) throws AbstractStreamDecoder.MalformedFrameException {
        switch (commandType) {
            case NOOP: {
                this.checkArguments(memento, 0);
                return Command.NOOP;
            }
            case BYE_ACK: {
                this.checkArguments(memento, 0);
                return Command.BYE_ACK;
            }
            case SKIP_SINCE_NEXT_TEST: {
                this.checkArguments(memento, 0);
                return Command.SKIP_SINCE_NEXT_TEST;
            }
            case TEST_SET_FINISHED: {
                this.checkArguments(memento, 0);
                return Command.TEST_SET_FINISHED;
            }
            case RUN_CLASS: {
                this.checkArguments(memento, 1);
                return Command.toRunClass((String)memento.getData().get(0));
            }
            case SHUTDOWN: {
                this.checkArguments(memento, 1);
                return Command.toShutdown(Shutdown.parameterOf((String)memento.getData().get(0)));
            }
        }
        throw new IllegalArgumentException("Missing a branch for the event type " + (Object)((Object)commandType));
    }

    @Override
    protected void debugStream(byte[] array, int position, int remaining) {
        if (this.debugSink == null) {
            return;
        }
        try {
            this.debugSink.write(array, position, remaining);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private OutputStream newDebugSink() {
        File sink = this.arguments.getCommandStreamBinaryFile();
        if (sink == null) {
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(sink, true);
            BufferedOutputStream os = new BufferedOutputStream(fos, 65536);
            ShutdownHookUtils.addShutDownHook(new Thread(new FutureTask<Object>(() -> {
                os.close();
                return null;
            })));
            return os;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.debugSink != null) {
            this.debugSink.close();
        }
    }
}

