/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class DumpStackTracesTimer
extends TimerTask {
    private static final int SECONDS_BEFORE_TIMEOUT_BUFFER = 120;
    private static final int SECONDS_BETWEEN_DUMPS = 5;
    private final String timeoutArg;

    private DumpStackTracesTimer(String timeoutArg) {
        this.timeoutArg = timeoutArg;
    }

    static void startStackDumpTimeoutTimer(String timeoutArg) {
        try {
            int delay = 120000;
            int timeout = Integer.parseInt(timeoutArg) - delay;
            String time0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date());
            DumpStackTracesTimer.logInfo("starting DumpStackTracesTimer with timeout=" + timeout + " at " + time0);
            if (timeout > 0) {
                new Timer("DumpStackTracesTimer", true).schedule((TimerTask)new DumpStackTracesTimer(timeoutArg), timeout);
            } else {
                DumpStackTracesTimer.logWarning("DumpStackTracesTimer argument error: '-timeout " + timeoutArg + "' was too short to accommodate time delay required (" + delay + ").");
            }
        }
        catch (NumberFormatException e) {
            DumpStackTracesTimer.logError("Error parsing timeout argument: " + timeoutArg, e);
        }
    }

    @Override
    public void run() {
        this.dump(0);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dump(5);
    }

    private void dump(int num) {
        long start = System.currentTimeMillis();
        this.logStackTraces(num);
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        float elapsedTimeSec = (float)elapsedTimeMillis / 1000.0f;
        DumpStackTracesTimer.logInfo("Seconds to do dump " + num + ": " + elapsedTimeSec);
    }

    private void logStackTraces(int num) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.dumpStackTraces(num, new PrintStream(outputStream));
        DumpStackTracesTimer.logWarning(outputStream.toString());
    }

    private void dumpStackTraces(int num, PrintStream out) {
        out.println("DumpStackTracesTimer almost reached timeout '" + this.timeoutArg + "'.");
        out.println("totalMemory:            " + Runtime.getRuntime().totalMemory());
        out.println("freeMemory (before GC): " + Runtime.getRuntime().freeMemory());
        out.flush();
        System.gc();
        out.println("freeMemory (after GC):  " + Runtime.getRuntime().freeMemory());
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date());
        out.println("Thread dump " + num + " at " + time + ":");
        out.flush();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            String name = entry.getKey().getName();
            StackTraceElement[] stack = entry.getValue();
            Exception exception = new Exception("ThreadDump for thread \"" + name + "\"");
            exception.setStackTrace(stack);
            exception.printStackTrace(out);
        }
        out.flush();
    }

    private static void logInfo(String message) {
        Status warningStatus = new Status(1, "org.eclipse.tycho.surefire.osgibooter", message);
        DumpStackTracesTimer.log((IStatus)warningStatus);
    }

    private static void logWarning(String message) {
        Status warningStatus = new Status(2, "org.eclipse.tycho.surefire.osgibooter", message);
        DumpStackTracesTimer.log((IStatus)warningStatus);
    }

    private static void logError(String message, Exception exception) {
        Status errorStatus = new Status(4, "org.eclipse.tycho.surefire.osgibooter", message, (Throwable)exception);
        DumpStackTracesTimer.log((IStatus)errorStatus);
    }

    private static void log(IStatus warningStatus) {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.tycho.surefire.osgibooter"));
        log.log(warningStatus);
    }
}

