/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.tycho.surefire.osgibooter.CombinedClassLoader;

class ContextFinderWithoutTychoBundle
extends ClassLoader
implements PrivilegedAction<List<ClassLoader>> {
    private static ThreadLocal<Set<String>> cycleDetector = new ThreadLocal();
    static ClassLoader finderClassLoader;
    static Finder contextFinder;
    private static Class<ContextFinderWithoutTychoBundle> THIS;
    private static Class<CombinedClassLoader> COMBINED;
    private final ClassLoader parentContextClassLoader;

    public ContextFinderWithoutTychoBundle(ClassLoader contextClassLoader) {
        super(contextClassLoader);
        this.parentContextClassLoader = contextClassLoader;
    }

    List<ClassLoader> basicFindClassLoaders() {
        Class<?>[] stack = contextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        ClassLoader previousLoader = null;
        for (int i = 1; i < stack.length; ++i) {
            ClassLoader tmp = stack[i].getClassLoader();
            if (stack[i] == THIS || stack[i] == COMBINED || tmp == null || tmp == this) continue;
            if (this.checkClassLoader(tmp) && previousLoader != tmp) {
                result.add(tmp);
                previousLoader = tmp;
            }
            if (tmp == finderClassLoader || this.isInstanceOfModuleClassLoader(tmp)) break;
        }
        return result;
    }

    private boolean isInstanceOfModuleClassLoader(ClassLoader tmp) {
        Class<?> current = tmp.getClass();
        do {
            if (!current.getName().equals("org.eclipse.osgi.internal.loader.ModuleClassLoader")) continue;
            return true;
        } while ((current = current.getSuperclass()) != null);
        return false;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        for (ClassLoader parent = classloader.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return false;
        }
        return true;
    }

    private List<ClassLoader> findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return AccessController.doPrivileged(this);
    }

    @Override
    public List<ClassLoader> run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String name) {
        Set<String> classesAndResources = cycleDetector.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            cycleDetector.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        cycleDetector.get().remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        if (!this.startLoading(arg0)) {
            throw new ClassNotFoundException(arg0);
        }
        try {
            List<ClassLoader> toConsult = this.findClassLoaders();
            for (ClassLoader classLoader : toConsult) {
                try {
                    Class<?> clazz = classLoader.loadClass(arg0);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            Class<?> clazz = this.parentContextClassLoader.loadClass(arg0);
            return clazz;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String arg0) {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            List<ClassLoader> toConsult = this.findClassLoaders();
            for (ClassLoader classLoader : toConsult) {
                URL result = classLoader.getResource(arg0);
                if (result == null) continue;
                URL uRL = result;
                return uRL;
            }
            URL uRL = super.getResource(arg0);
            return uRL;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String arg0) throws IOException {
        if (!this.startLoading(arg0)) {
            return Collections.enumeration(Collections.emptyList());
        }
        try {
            ClassLoader classLoader;
            List<ClassLoader> toConsult = this.findClassLoaders();
            Enumeration<URL> result = null;
            Object object = toConsult.iterator();
            while (object.hasNext() && ((result = (classLoader = object.next()).getResources(arg0)) == null || !result.hasMoreElements())) {
            }
            object = ContextFinderWithoutTychoBundle.compoundEnumerations(result, super.getResources(arg0));
            return object;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    public static <E> Enumeration<E> compoundEnumerations(Enumeration<E> list1, Enumeration<E> list2) {
        if (list2 == null || !list2.hasMoreElements()) {
            return list1 == null ? Collections.emptyEnumeration() : list1;
        }
        if (list1 == null || !list1.hasMoreElements()) {
            return list2 == null ? Collections.emptyEnumeration() : list2;
        }
        ArrayList<E> compoundResults = new ArrayList<E>();
        while (list1.hasMoreElements()) {
            compoundResults.add(list1.nextElement());
        }
        while (list2.hasMoreElements()) {
            E item = list2.nextElement();
            if (compoundResults.contains(item)) continue;
            compoundResults.add(item);
        }
        return Collections.enumeration(compoundResults);
    }

    static {
        AccessController.doPrivileged(() -> {
            finderClassLoader = ContextFinderWithoutTychoBundle.class.getClassLoader();
            contextFinder = new Finder();
            return null;
        });
        THIS = ContextFinderWithoutTychoBundle.class;
        COMBINED = CombinedClassLoader.class;
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

