/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;

@API(status=API.Status.STABLE, since="1.6")
public class NestedMethodSelector
implements DiscoverySelector {
    private final NestedClassSelector nestedClassSelector;
    private final MethodSelector methodSelector;

    NestedMethodSelector(List<String> enclosingClassNames, String nestedClassName, String methodName) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClassNames, nestedClassName);
        this.methodSelector = new MethodSelector(nestedClassName, methodName);
    }

    NestedMethodSelector(List<String> enclosingClassNames, String nestedClassName, String methodName, String methodParameterTypes) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClassNames, nestedClassName);
        this.methodSelector = new MethodSelector(nestedClassName, methodName, methodParameterTypes);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, methodName);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, String methodParameterTypes) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, methodName, methodParameterTypes);
    }

    NestedMethodSelector(List<Class<?>> enclosingClasses, Class<?> nestedClass, Method method) {
        this.nestedClassSelector = new NestedClassSelector(enclosingClasses, nestedClass);
        this.methodSelector = new MethodSelector(nestedClass, method);
    }

    public List<String> getEnclosingClassNames() {
        return this.nestedClassSelector.getEnclosingClassNames();
    }

    public List<Class<?>> getEnclosingClasses() {
        return this.nestedClassSelector.getEnclosingClasses();
    }

    public String getNestedClassName() {
        return this.nestedClassSelector.getNestedClassName();
    }

    public Class<?> getNestedClass() {
        return this.nestedClassSelector.getNestedClass();
    }

    public String getMethodName() {
        return this.methodSelector.getMethodName();
    }

    public Method getMethod() {
        return this.methodSelector.getJavaMethod();
    }

    public String getMethodParameterTypes() {
        return this.methodSelector.getMethodParameterTypes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedMethodSelector that = (NestedMethodSelector)o;
        return this.nestedClassSelector.equals(that.nestedClassSelector) && this.methodSelector.equals(that.methodSelector);
    }

    public int hashCode() {
        return Objects.hash(this.nestedClassSelector, this.methodSelector);
    }

    public String toString() {
        return new ToStringBuilder(this).append("enclosingClassNames", this.getEnclosingClassNames()).append("nestedClassName", this.getNestedClassName()).append("methodName", this.getMethodName()).append("methodParameterTypes", this.getMethodParameterTypes()).toString();
    }
}

