/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.Method;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.extension.RepeatedTestDisplayNameFormatter;
import org.junit.jupiter.engine.extension.RepeatedTestInvocationContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class RepeatedTestExtension
implements TestTemplateInvocationContextProvider {
    RepeatedTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationUtils.isAnnotated(context.getTestMethod(), RepeatedTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        String displayName = context.getDisplayName();
        RepeatedTest repeatedTest = AnnotationUtils.findAnnotation(testMethod, RepeatedTest.class).get();
        int totalRepetitions = this.totalRepetitions(repeatedTest, testMethod);
        RepeatedTestDisplayNameFormatter formatter = this.displayNameFormatter(repeatedTest, testMethod, displayName);
        return IntStream.rangeClosed(1, totalRepetitions).mapToObj(repetition -> new RepeatedTestInvocationContext(repetition, totalRepetitions, formatter));
    }

    private int totalRepetitions(RepeatedTest repeatedTest, Method method) {
        int repetitions = repeatedTest.value();
        Preconditions.condition(repetitions > 0, () -> String.format("Configuration error: @RepeatedTest on method [%s] must be declared with a positive 'value'.", method));
        return repetitions;
    }

    private RepeatedTestDisplayNameFormatter displayNameFormatter(RepeatedTest repeatedTest, Method method, String displayName) {
        String pattern = Preconditions.notBlank(repeatedTest.name().trim(), () -> String.format("Configuration error: @RepeatedTest on method [%s] must be declared with a non-empty name.", method));
        return new RepeatedTestDisplayNameFormatter(pattern, displayName);
    }
}

