/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.FileSystemSource;

@API(status=API.Status.STABLE, since="1.0")
public class DirectorySource
implements FileSystemSource {
    private static final long serialVersionUID = 1L;
    private final File directory;

    public static DirectorySource from(File directory) {
        return new DirectorySource(directory);
    }

    private DirectorySource(File directory) {
        Preconditions.notNull(directory, "directory must not be null");
        try {
            this.directory = directory.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new JUnitException("Failed to retrieve canonical path for directory: " + directory, ex);
        }
    }

    @Override
    public final URI getUri() {
        return this.getFile().toURI();
    }

    @Override
    public final File getFile() {
        return this.directory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectorySource that = (DirectorySource)o;
        return this.directory.equals(that.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("directory", this.directory).toString();
    }
}

