/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

final class DisplayNameUtils {
    private static final Logger logger = LoggerFactory.getLogger(DisplayNameUtils.class);
    private static final DisplayNameGenerator standardGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.Standard.class);
    private static final DisplayNameGenerator simpleGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.Simple.class);
    private static final DisplayNameGenerator replaceUnderscoresGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.ReplaceUnderscores.class);
    private static final DisplayNameGenerator indicativeSentencesGenerator = DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.IndicativeSentences.class);

    DisplayNameUtils() {
    }

    static String determineDisplayName(AnnotatedElement element, Supplier<String> displayNameSupplier) {
        Preconditions.notNull(element, "Annotated element must not be null");
        Optional<DisplayName> displayNameAnnotation = AnnotationSupport.findAnnotation(element, DisplayName.class);
        if (displayNameAnnotation.isPresent()) {
            String displayName = displayNameAnnotation.get().value().trim();
            if (StringUtils.isBlank(displayName)) {
                logger.warn(() -> String.format("Configuration error: @DisplayName on [%s] must be declared with a non-empty value.", element));
            } else {
                return displayName;
            }
        }
        return displayNameSupplier.get();
    }

    static String determineDisplayNameForMethod(Supplier<List<Class<?>>> enclosingInstanceTypes, Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        return DisplayNameUtils.determineDisplayName(testMethod, DisplayNameUtils.createDisplayNameSupplierForMethod(enclosingInstanceTypes, testClass, testMethod, configuration));
    }

    static Supplier<String> createDisplayNameSupplierForClass(Class<?> testClass, JupiterConfiguration configuration) {
        return DisplayNameUtils.createDisplayNameSupplier(Collections::emptyList, testClass, configuration, (generator, __) -> generator.generateDisplayNameForClass(testClass));
    }

    static Supplier<String> createDisplayNameSupplierForNestedClass(Supplier<List<Class<?>>> enclosingInstanceTypesSupplier, Class<?> testClass, JupiterConfiguration configuration) {
        return DisplayNameUtils.createDisplayNameSupplier(enclosingInstanceTypesSupplier, testClass, configuration, (generator, enclosingInstanceTypes) -> generator.generateDisplayNameForNestedClass(enclosingInstanceTypes, testClass));
    }

    private static Supplier<String> createDisplayNameSupplierForMethod(Supplier<List<Class<?>>> enclosingInstanceTypesSupplier, Class<?> testClass, Method testMethod, JupiterConfiguration configuration) {
        return DisplayNameUtils.createDisplayNameSupplier(enclosingInstanceTypesSupplier, testClass, configuration, (generator, enclosingInstanceTypes) -> generator.generateDisplayNameForMethod(enclosingInstanceTypes, testClass, testMethod));
    }

    private static Supplier<String> createDisplayNameSupplier(Supplier<List<Class<?>>> enclosingInstanceTypesSupplier, Class<?> testClass, JupiterConfiguration configuration, BiFunction<DisplayNameGenerator, List<Class<?>>, String> generatorFunction) {
        return () -> {
            List<Class<?>> enclosingInstanceTypes = DisplayNameUtils.makeUnmodifiable((List)enclosingInstanceTypesSupplier.get());
            return DisplayNameUtils.findDisplayNameGenerator(enclosingInstanceTypes, testClass).map(it -> (String)generatorFunction.apply((DisplayNameGenerator)it, enclosingInstanceTypes)).orElseGet(() -> (String)generatorFunction.apply(configuration.getDefaultDisplayNameGenerator(), enclosingInstanceTypes));
        };
    }

    private static <T> List<T> makeUnmodifiable(List<T> list) {
        return list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    private static Optional<DisplayNameGenerator> findDisplayNameGenerator(List<Class<?>> enclosingInstanceTypes, Class<?> testClass) {
        Preconditions.notNull(testClass, "Test class must not be null");
        return AnnotationSupport.findAnnotation(testClass, DisplayNameGeneration.class, enclosingInstanceTypes).map(DisplayNameGeneration::value).map(displayNameGeneratorClass -> {
            if (displayNameGeneratorClass == DisplayNameGenerator.Standard.class) {
                return standardGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.Simple.class) {
                return simpleGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.ReplaceUnderscores.class) {
                return replaceUnderscoresGenerator;
            }
            if (displayNameGeneratorClass == DisplayNameGenerator.IndicativeSentences.class) {
                return indicativeSentencesGenerator;
            }
            return (DisplayNameGenerator)ReflectionSupport.newInstance(displayNameGeneratorClass, new Object[0]);
        });
    }
}

