/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.MediaType;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.execution.DefaultExecutableInvoker;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.jupiter.engine.extension.ExtensionContextInternal;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

abstract class AbstractExtensionContext<T extends TestDescriptor>
implements ExtensionContextInternal,
AutoCloseable {
    private static final NamespacedHierarchicalStore.CloseAction<ExtensionContext.Namespace> CLOSE_RESOURCES = (__, ___, value) -> {
        if (value instanceof ExtensionContext.Store.CloseableResource) {
            ((ExtensionContext.Store.CloseableResource)value).close();
        }
    };
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final T testDescriptor;
    private final Set<String> tags;
    private final JupiterConfiguration configuration;
    private final NamespacedHierarchicalStore<ExtensionContext.Namespace> valuesStore;
    private final ExecutableInvoker executableInvoker;
    private final ExtensionRegistry extensionRegistry;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, T testDescriptor, JupiterConfiguration configuration, ExtensionRegistry extensionRegistry) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        Preconditions.notNull(configuration, "JupiterConfiguration must not be null");
        Preconditions.notNull(extensionRegistry, "ExtensionRegistry must not be null");
        this.executableInvoker = new DefaultExecutableInvoker(this, extensionRegistry);
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.configuration = configuration;
        this.valuesStore = AbstractExtensionContext.createStore(parent);
        this.extensionRegistry = extensionRegistry;
        this.tags = testDescriptor.getTags().stream().map(TestTag::getName).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    private static NamespacedHierarchicalStore<ExtensionContext.Namespace> createStore(ExtensionContext parent) {
        NamespacedHierarchicalStore<ExtensionContext.Namespace> parentStore = null;
        if (parent != null) {
            parentStore = ((AbstractExtensionContext)parent).valuesStore;
        }
        return new NamespacedHierarchicalStore<ExtensionContext.Namespace>(parentStore, CLOSE_RESOURCES);
    }

    @Override
    public void close() {
        this.valuesStore.close();
    }

    public String getUniqueId() {
        return this.getTestDescriptor().getUniqueId().toString();
    }

    public String getDisplayName() {
        return this.getTestDescriptor().getDisplayName();
    }

    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished((TestDescriptor)this.testDescriptor, ReportEntry.from(values));
    }

    public void publishFile(String name, MediaType mediaType, ThrowingConsumer<Path> action) {
        Preconditions.notNull(name, "name must not be null");
        Preconditions.notNull(mediaType, "mediaType must not be null");
        Preconditions.notNull(action, "action must not be null");
        this.publishFileEntry(name, action, file -> {
            Preconditions.condition(Files.isRegularFile(file, new LinkOption[0]), () -> "Published path must be a regular file: " + file);
            return FileEntry.from(file, mediaType.toString());
        });
    }

    public void publishDirectory(String name, ThrowingConsumer<Path> action) {
        Preconditions.notNull(name, "name must not be null");
        Preconditions.notNull(action, "action must not be null");
        ThrowingConsumer enhancedAction = path -> {
            Files.createDirectory(path, new FileAttribute[0]);
            action.accept(path);
        };
        this.publishFileEntry(name, (ThrowingConsumer<Path>)enhancedAction, file -> {
            Preconditions.condition(Files.isDirectory(file, new LinkOption[0]), () -> "Published path must be a directory: " + file);
            return FileEntry.from(file, null);
        });
    }

    private void publishFileEntry(String name, ThrowingConsumer<Path> action, Function<Path, FileEntry> fileEntryCreator) {
        Path dir = this.createOutputDirectory();
        Path path = dir.resolve(name);
        Preconditions.condition(path.getParent().equals(dir), () -> "name must not contain path separators: " + name);
        try {
            action.accept((Object)path);
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            throw new JUnitException("Failed to publish path", t);
        }
        Preconditions.condition(Files.exists(path, new LinkOption[0]), () -> "Published path must exist: " + path);
        FileEntry fileEntry = fileEntryCreator.apply(path);
        this.engineExecutionListener.fileEntryPublished((TestDescriptor)this.testDescriptor, fileEntry);
    }

    private Path createOutputDirectory() {
        try {
            return this.configuration.getOutputDirectoryProvider().createOutputDirectory((TestDescriptor)this.testDescriptor);
        }
        catch (IOException e) {
            throw new JUnitException("Failed to create output directory", e);
        }
    }

    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ExtensionContext getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected T getTestDescriptor() {
        return this.testDescriptor;
    }

    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        Preconditions.notNull(namespace, "Namespace must not be null");
        return new NamespaceAwareStore(this.valuesStore, namespace);
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(this.tags);
    }

    public Optional<String> getConfigurationParameter(String key) {
        return this.configuration.getRawConfigurationParameter(key);
    }

    public <V> Optional<V> getConfigurationParameter(String key, Function<String, V> transformer) {
        return this.configuration.getRawConfigurationParameter(key, transformer);
    }

    public ExecutionMode getExecutionMode() {
        return this.toJupiterExecutionMode(this.getPlatformExecutionMode());
    }

    public ExecutableInvoker getExecutableInvoker() {
        return this.executableInvoker;
    }

    @Override
    public <E extends Extension> List<E> getExtensions(Class<E> extensionType) {
        return this.extensionRegistry.getExtensions(extensionType);
    }

    protected abstract Node.ExecutionMode getPlatformExecutionMode();

    private ExecutionMode toJupiterExecutionMode(Node.ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return ExecutionMode.SAME_THREAD;
            }
        }
        throw new JUnitException("Unknown ExecutionMode: " + (Object)((Object)mode));
    }
}

