/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitplatform;

import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;

class LazyLauncher
implements Launcher,
AutoCloseable {
    private AutoCloseable launcherSession;
    private Launcher launcher;

    LazyLauncher() {
    }

    public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
        this.launcher().registerLauncherDiscoveryListeners(listeners);
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        this.launcher().registerTestExecutionListeners(testExecutionListeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest launcherDiscoveryRequest) {
        return this.launcher().discover(launcherDiscoveryRequest);
    }

    @Override
    public void execute(LauncherDiscoveryRequest launcherDiscoveryRequest, TestExecutionListener ... testExecutionListeners) {
        this.launcher().execute(launcherDiscoveryRequest, testExecutionListeners);
    }

    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        this.launcher().execute(testPlan, listeners);
    }

    private Launcher launcher() {
        if (this.launcher == null) {
            try {
                Class<?> sessionClass = Class.forName("org.junit.platform.launcher.LauncherSession");
                this.launcherSession = (AutoCloseable)ReflectionUtils.invokeGetter(LauncherFactory.class, null, (String)"openSession");
                this.launcher = (Launcher)ReflectionUtils.invokeGetter(sessionClass, (Object)this.launcherSession, (String)"getLauncher");
            }
            catch (ClassNotFoundException e) {
                this.launcher = LauncherFactory.create();
            }
        }
        return this.launcher;
    }

    @Override
    public void close() throws Exception {
        if (this.launcherSession != null) {
            this.launcherSession.close();
            this.launcherSession = null;
        }
        this.launcher = null;
    }
}

