/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.LauncherDiscoveryRequest;

class Root {
    private final Map<TestEngine, TestDescriptor> testEngineDescriptors = new LinkedHashMap<TestEngine, TestDescriptor>(4);

    Root() {
    }

    void add(TestEngine engine, TestDescriptor testDescriptor) {
        this.testEngineDescriptors.put(engine, testDescriptor);
    }

    Iterable<TestEngine> getTestEngines() {
        return this.testEngineDescriptors.keySet();
    }

    Collection<TestDescriptor> getEngineDescriptors() {
        return this.testEngineDescriptors.values();
    }

    TestDescriptor getTestDescriptorFor(TestEngine testEngine) {
        return this.testEngineDescriptors.get(testEngine);
    }

    void applyPostDiscoveryFilters(LauncherDiscoveryRequest discoveryRequest) {
        Filter postDiscoveryFilter = Filter.composeFilters(discoveryRequest.getPostDiscoveryFilters());
        TestDescriptor.Visitor removeExcludedTestDescriptors = descriptor -> {
            if (!descriptor.isRoot() && this.isExcluded(descriptor, postDiscoveryFilter)) {
                descriptor.removeFromHierarchy();
            }
        };
        this.acceptInAllTestEngines(removeExcludedTestDescriptors);
    }

    void prune() {
        this.acceptInAllTestEngines(TestDescriptor::prune);
    }

    private boolean isExcluded(TestDescriptor descriptor, Filter<TestDescriptor> postDiscoveryFilter) {
        return descriptor.getChildren().isEmpty() && postDiscoveryFilter.apply(descriptor).excluded();
    }

    private void acceptInAllTestEngines(TestDescriptor.Visitor visitor) {
        this.testEngineDescriptors.values().forEach(descriptor -> descriptor.accept(visitor));
    }
}

