/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.FilePosition;

@API(status=API.Status.STABLE, since="1.0")
public class ClassSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final FilePosition filePosition;
    private Class<?> javaClass;

    public static ClassSource from(String className) {
        return new ClassSource(className);
    }

    public static ClassSource from(String className, FilePosition filePosition) {
        return new ClassSource(className, filePosition);
    }

    public static ClassSource from(Class<?> javaClass) {
        return new ClassSource(javaClass);
    }

    public static ClassSource from(Class<?> javaClass, FilePosition filePosition) {
        return new ClassSource(javaClass, filePosition);
    }

    private ClassSource(String className) {
        this(className, null);
    }

    private ClassSource(String className, FilePosition filePosition) {
        this.className = className;
        this.filePosition = filePosition;
    }

    private ClassSource(Class<?> javaClass) {
        this(javaClass, null);
    }

    private ClassSource(Class<?> javaClass, FilePosition filePosition) {
        this.javaClass = Preconditions.notNull(javaClass, "class must not be null");
        this.className = this.javaClass.getName();
        this.filePosition = filePosition;
    }

    public final String getClassName() {
        return this.className;
    }

    public final Class<?> getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = ReflectionUtils.loadClass(this.className).orElseThrow(() -> new PreconditionViolationException("Could not load class with name: " + this.className));
        }
        return this.javaClass;
    }

    public final Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSource that = (ClassSource)o;
        return Objects.equals(this.javaClass, that.javaClass) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).append("filePosition", this.filePosition).toString();
    }
}

