/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.vintage.engine.discovery.TestClassRequest;

class TestClassCollector {
    private final Set<Class<?>> completeTestClasses = new LinkedHashSet();
    private final Map<Class<?>, List<RunnerTestDescriptorAwareFilter>> filteredTestClasses = new LinkedHashMap();

    TestClassCollector() {
    }

    void addCompletely(Class<?> testClass) {
        this.completeTestClasses.add(testClass);
    }

    void addFiltered(Class<?> testClass, RunnerTestDescriptorAwareFilter filter) {
        this.filteredTestClasses.computeIfAbsent(testClass, key -> new ArrayList()).add(filter);
    }

    Stream<TestClassRequest> toRequests() {
        return Stream.concat(this.completeRequests(), this.filteredRequests());
    }

    private Stream<TestClassRequest> completeRequests() {
        return this.completeTestClasses.stream().map(TestClassRequest::new);
    }

    private Stream<TestClassRequest> filteredRequests() {
        return this.filteredTestClasses.entrySet().stream().filter(FunctionUtils.where(Map.Entry::getKey, testClass -> !this.completeTestClasses.contains(testClass))).map(entry -> new TestClassRequest((Class)entry.getKey(), (List)entry.getValue()));
    }
}

