/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.director.shared;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.p2.tools.director.shared.DirectorRuntime;

public abstract class AbstractDirectorApplicationCommand
implements DirectorRuntime.Command {
    private StringJoiner metadataSources = new StringJoiner(",");
    private StringJoiner artifactSources = new StringJoiner(",");
    private StringJoiner unitsToInstall = new StringJoiner(",");
    private String profileName;
    private TargetEnvironment environment;
    private boolean installFeatures;
    private Map<String, String> profileProperties = Map.of();
    private boolean verifyOnly;
    private File destination;
    private File bundlePool;

    @Override
    public final void addMetadataSources(Iterable<URI> metadataRepositories) {
        for (URI repositoryUrl : metadataRepositories) {
            this.metadataSources.add(repositoryUrl.toString());
        }
    }

    @Override
    public final void addArtifactSources(Iterable<URI> artifactRepositories) {
        for (URI repositoryUrl : artifactRepositories) {
            this.artifactSources.add(repositoryUrl.toString());
        }
    }

    @Override
    public final void addUnitToInstall(String id) {
        this.unitsToInstall.add(id);
    }

    @Override
    public final void addUnitToInstall(DependencySeed dependency) {
        String uid = "eclipse-feature".equals(dependency.getType()) ? String.valueOf(dependency.getId()) + ".feature.group" : dependency.getId();
        this.unitsToInstall.add(uid);
    }

    @Override
    public final void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Override
    public final void setEnvironment(TargetEnvironment env) {
        this.environment = env;
    }

    @Override
    public final void setInstallFeatures(boolean installFeatures) {
        this.installFeatures = installFeatures;
    }

    @Override
    public final void setVerifyOnly(boolean verifyOnly) {
        this.verifyOnly = verifyOnly;
    }

    @Override
    public final void setDestination(File path) {
        this.destination = path;
    }

    @Override
    public void setBundlePool(File path) {
        this.bundlePool = path;
    }

    @Override
    public void setProfileProperties(Map<String, String> profileProperties) {
        this.profileProperties = profileProperties == null ? Map.of() : profileProperties;
    }

    protected List<String> getDirectorApplicationArguments() {
        CommandLineArguments args = new CommandLineArguments();
        args.addUnlessEmpty("-metadataRepository", this.metadataSources);
        args.addUnlessEmpty("-artifactRepository", this.artifactSources);
        args.addUnlessEmpty("-installIU", this.unitsToInstall);
        args.add("-destination", this.destination.getAbsolutePath());
        args.add("-profile", this.profileName);
        HashMap<String, String> props = new HashMap<String, String>(this.profileProperties);
        props.put("org.eclipse.update.install.features", Boolean.toString(this.installFeatures));
        args.add("-profileProperties", props.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + '=' + (String)entry.getValue()).collect(Collectors.joining(",")));
        args.add("-roaming");
        if (this.verifyOnly) {
            args.add("-verifyOnly");
        }
        if (this.bundlePool != null) {
            args.add("-bundlePool", this.bundlePool.getAbsolutePath());
        }
        if (this.environment != null) {
            args.add("-p2.os", this.environment.getOs());
            args.add("-p2.ws", this.environment.getWs());
            args.add("-p2.arch", this.environment.getArch());
        }
        return args.asList();
    }

    private static class CommandLineArguments {
        List<String> arguments = new ArrayList<String>();

        private CommandLineArguments() {
        }

        void add(String flag) {
            this.arguments.add(flag);
        }

        void add(String parameterName, String parameterValue) {
            this.arguments.add(parameterName);
            this.arguments.add(parameterValue);
        }

        void addUnlessEmpty(String parameterName, StringJoiner parameterValue) {
            if (parameterValue.length() > 0) {
                this.add(parameterName, parameterValue.toString());
            }
        }

        public List<String> asList() {
            return new ArrayList<String>(this.arguments);
        }
    }
}

