/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductContentType;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.core.shared.VersioningHelper;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.tools.publisher.ProductVersionExpansionRun;

class ExpandedProduct
implements IProductDescriptor {
    private final IProductDescriptor defaults;
    private P2TargetPlatform targetPlatform;
    private Interpolator interpolator;
    private final String expandedVersion;
    private List<IVersionedId> expandedBundles = null;
    private List<IVersionedId> expandedFeatures = null;
    private List<IInstallableUnit> expandedRootFeatures = Collections.emptyList();
    private final MultiLineLogger logger;

    public ExpandedProduct(IProductDescriptor originalProduct, String buildQualifier, P2TargetPlatform targetPlatform, Interpolator interpolator, MavenLogger logger) {
        this.defaults = originalProduct;
        this.expandedVersion = VersioningHelper.expandQualifier((String)originalProduct.getVersion(), (String)buildQualifier);
        this.targetPlatform = targetPlatform;
        this.interpolator = interpolator;
        this.logger = new MultiLineLogger(logger);
        this.expandVersions();
    }

    public String getVersion() {
        return this.expandedVersion;
    }

    public List<IVersionedId> getBundles(boolean includeFragments) {
        if (!includeFragments) {
            throw new UnsupportedOperationException();
        }
        if (this.getProductContentType() == ProductContentType.FEATURES) {
            return this.defaults.getBundles(includeFragments);
        }
        return this.expandedBundles;
    }

    public List<IVersionedId> getFragments() {
        throw new UnsupportedOperationException();
    }

    public List<IVersionedId> getFeatures() {
        return this.getFeatures(1);
    }

    public List<IVersionedId> getFeatures(int options) {
        if (options == 1) {
            return this.expandedFeatures;
        }
        throw new UnsupportedOperationException();
    }

    public List<IInstallableUnit> getRootFeatures() {
        return this.expandedRootFeatures;
    }

    private void expandVersions() {
        ProductContentType contentType = this.getProductContentType();
        ProductVersionExpansionRun resolver = new ProductVersionExpansionRun(this.targetPlatform, this.getLocation());
        if (contentType != ProductContentType.FEATURES) {
            this.expandedBundles = resolver.resolveReferences("plugin", "eclipse-plugin", this.defaults.getBundles(true));
        }
        if (contentType != ProductContentType.BUNDLES) {
            this.expandedFeatures = resolver.resolveReferences("feature", "eclipse-feature", this.defaults.getFeatures(1));
            this.expandedRootFeatures = resolver.resolveReferencesToIUs("feature", "eclipse-feature", this.defaults.getFeatures(2));
        }
        resolver.reportErrors((MavenLogger)this.logger);
    }

    public Map<String, String> getConfigurationProperties() {
        return this.expandVariables(this.defaults.getConfigurationProperties());
    }

    public Map<String, String> getConfigurationProperties(String os, String arch) {
        return this.expandVariables(this.defaults.getConfigurationProperties(os, arch));
    }

    private Map<String, String> expandVariables(Map<String, String> originalMap) {
        LinkedHashMap<String, String> expandedMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            expandedMap.put(entry.getKey(), this.interpolator.interpolate(entry.getValue()));
        }
        return expandedMap;
    }

    public boolean hasBundles(boolean includeFragments) {
        return this.defaults.hasBundles(includeFragments);
    }

    public boolean hasFeatures() {
        return this.defaults.hasFeatures();
    }

    public String getLauncherName() {
        return this.defaults.getLauncherName();
    }

    public String getConfigIniPath(String os) {
        return this.defaults.getConfigIniPath(os);
    }

    public String getId() {
        return this.defaults.getId();
    }

    public String getProductId() {
        return this.defaults.getProductId();
    }

    public String getApplication() {
        return this.defaults.getApplication();
    }

    public String getSplashLocation() {
        return this.defaults.getSplashLocation();
    }

    public String getProductName() {
        return this.defaults.getProductName();
    }

    public boolean useFeatures() {
        return this.defaults.useFeatures();
    }

    public ProductContentType getProductContentType() {
        return this.defaults.getProductContentType();
    }

    public String getVMArguments(String os) {
        return this.defaults.getVMArguments(os);
    }

    public String getVMArguments(String os, String arch) {
        return this.defaults.getVMArguments(os, arch);
    }

    public String getProgramArguments(String os) {
        return this.defaults.getProgramArguments(os);
    }

    public String getProgramArguments(String os, String arch) {
        return this.defaults.getProgramArguments(os, arch);
    }

    public String[] getIcons(String os) {
        Object[] icons = this.defaults.getIcons(os);
        this.logger.debug("Getting the following icon paths from defaults: " + Arrays.toString(icons));
        int i = 0;
        while (i < icons.length) {
            icons[i] = this.guessRealIconPath((String)icons[i]);
            ++i;
        }
        return icons;
    }

    private String guessRealIconPath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                File productFolder = this.defaults.getLocation().getParentFile();
                String productPath = productFolder.getCanonicalPath();
                String iconPath = file.getCanonicalPath();
                if (iconPath.startsWith(productPath)) {
                    File parentDirectory;
                    String rawPath = iconPath.substring(productPath.length());
                    if (rawPath.startsWith("/") || rawPath.startsWith(File.separator)) {
                        rawPath = rawPath.substring(1);
                    }
                    if ((parentDirectory = productFolder.getParentFile()) != null) {
                        File guessedFile = new File(parentDirectory, rawPath);
                        String absolutePath = guessedFile.getAbsolutePath();
                        this.logger.debug("raw path is " + rawPath + ", guessed path is " + absolutePath);
                        if (guessedFile.exists()) {
                            return absolutePath;
                        }
                    }
                }
                this.logger.warn("Icon path " + path + " does not exist and can't be determined by tycho, make sure that either the icon path is relative to the product file, or denotes a folder in the parent path of the product! (current product path is " + productPath + ")");
            }
            catch (IOException e) {
                this.logger.warn("can't guess icon path because of I/O problem", (Throwable)e);
            }
        }
        return path;
    }

    public List<BundleInfo> getBundleInfos() {
        return this.defaults.getBundleInfos();
    }

    public File getLocation() {
        return this.defaults.getLocation();
    }

    public boolean includeLaunchers() {
        return this.defaults.includeLaunchers();
    }

    public String getLicenseURL() {
        return this.defaults.getLicenseURL();
    }

    public String getLicenseText() {
        return this.defaults.getLicenseText();
    }

    public List<IRepositoryReference> getRepositoryEntries() {
        return this.defaults.getRepositoryEntries();
    }

    public String getVM(String os) {
        return this.defaults.getVM(os);
    }
}

