/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.p2.target.ee.CustomEEResolutionHints;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.DependencySeedUtil;
import org.eclipse.tycho.p2.tools.publisher.PublisherActionRunner;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.repository.publishing.PublishingRepository;

class PublisherServiceImpl
implements PublisherService {
    private final PublisherActionRunner publisherRunner;
    private final String qualifier;
    private final PublishingRepository publishingRepository;

    public PublisherServiceImpl(PublisherActionRunner publisherRunner, String qualifier, PublishingRepository publishingRepository) {
        this.publisherRunner = publisherRunner;
        this.qualifier = qualifier;
        this.publishingRepository = publishingRepository;
    }

    public Collection<DependencySeed> publishCategories(File categoryDefinition) throws FacadeException, IllegalStateException {
        CategoryXMLAction categoryXMLAction = new CategoryXMLAction(categoryDefinition.toURI(), this.qualifier);
        Collection<IInstallableUnit> allIUs = this.publisherRunner.executeAction((IPublisherAction)categoryXMLAction, this.publishingRepository.getMetadataRepository(), (IArtifactRepository)this.publishingRepository.getArtifactRepository(), new IPublisherAdvice[0]);
        return PublisherServiceImpl.toSeeds(null, allIUs);
    }

    public Collection<DependencySeed> publishEEProfile(File profileFile) throws FacadeException {
        this.validateProfile(profileFile);
        JREAction jreAction = new JREAction(profileFile);
        Collection<IInstallableUnit> allIUs = this.publisherRunner.executeAction((IPublisherAction)jreAction, this.publishingRepository.getMetadataRepository(), (IArtifactRepository)this.publishingRepository.getArtifactRepository(), new IPublisherAdvice[0]);
        return PublisherServiceImpl.toSeeds(null, allIUs);
    }

    public Collection<DependencySeed> publishEEProfile(String profileName) throws FacadeException {
        JREAction jreAction = new JREAction(profileName);
        Collection<IInstallableUnit> allIUs = this.publisherRunner.executeAction((IPublisherAction)jreAction, this.publishingRepository.getMetadataRepository(), (IArtifactRepository)this.publishingRepository.getArtifactRepository(), new IPublisherAdvice[0]);
        return PublisherServiceImpl.toSeeds(null, allIUs);
    }

    void validateProfile(File profileFile) throws FacadeException {
        Properties profileProperties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream stream = new FileInputStream(profileFile);){
                profileProperties.load(stream);
                this.validateProfile(profileProperties, profileFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FacadeException((Throwable)e);
        }
    }

    private void validateProfile(Properties props, File profileFile) throws FacadeException {
        String simpleFileName = profileFile.getName();
        if (!simpleFileName.endsWith(".profile")) {
            throw new FacadeException("Profile file name must end with '.profile': " + profileFile);
        }
        String profileNameKey = "osgi.java.profile.name";
        String profileName = props.getProperty(profileNameKey);
        if (profileName == null) {
            throw new FacadeException("Mandatory property '" + profileNameKey + "' is missing in profile file " + profileFile);
        }
        new CustomEEResolutionHints(profileName);
        String fileNamePrefix = simpleFileName.substring(0, simpleFileName.length() - ".profile".length()).toLowerCase(Locale.ENGLISH);
        if (!fileNamePrefix.equals(profileName.toLowerCase(Locale.ENGLISH))) {
            throw new FacadeException("Profile file with 'osgi.java.profile.name=" + profileName + "' must be named '" + profileName + ".profile', but found file name: '" + simpleFileName + "'");
        }
    }

    private static Collection<DependencySeed> toSeeds(String type, Collection<IInstallableUnit> units) {
        ArrayList<DependencySeed> result = new ArrayList<DependencySeed>(units.size());
        for (IInstallableUnit unit : units) {
            result.add(DependencySeedUtil.createSeed(type, unit));
        }
        return result;
    }
}

