/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.net.URI;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.RepositoryReferences;

class PublisherInfoTemplate {
    private final RepositoryReferences contextRepos;
    private final BuildContext context;
    private final IProvisioningAgent agent;

    public PublisherInfoTemplate(RepositoryReferences contextRepos, BuildContext context, IProvisioningAgent agent) {
        this.contextRepos = contextRepos;
        this.context = context;
        this.agent = agent;
    }

    public IPublisherInfo newPublisherInfo(IMetadataRepository metadataOutput, IArtifactRepository artifactsOutput) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setMetadataRepository(metadataOutput);
        publisherInfo.setArtifactRepository(artifactsOutput);
        publisherInfo.setArtifactOptions(3);
        this.setContextMetadataRepos(publisherInfo);
        this.setTargetEnvironments(publisherInfo);
        return publisherInfo;
    }

    private void setContextMetadataRepos(PublisherInfo publisherInfo) {
        if (this.contextRepos.getMetadataRepositories().size() > 0) {
            CompositeMetadataRepository contextMetadataComposite = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.agent);
            for (URI repositoryLocation : this.contextRepos.getMetadataRepositories()) {
                contextMetadataComposite.addChild(repositoryLocation);
            }
            publisherInfo.setContextMetadataRepository((IMetadataRepository)contextMetadataComposite);
        }
    }

    private void setTargetEnvironments(PublisherInfo publisherInfo) {
        int writeIx = 0;
        String[] configSpecs = new String[this.context.getEnvironments().size()];
        for (TargetEnvironment environment : this.context.getEnvironments()) {
            configSpecs[writeIx++] = environment.toConfigSpec();
        }
        publisherInfo.setConfigurations(configSpecs);
    }
}

