/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.repository.GAV;

public class RepositoryLayoutHelper {
    public static String getRelativePath(GAV gav, String classifier, String type, MavenContext mavenContext) {
        return RepositoryLayoutHelper.getRelativePath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), classifier, type, mavenContext);
    }

    public static String getRelativePath(GAV gav, String classifier, String extension) {
        if (extension == null) {
            extension = "jar";
        }
        return RepositoryLayoutHelper.getRelativePath(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), classifier, extension);
    }

    public static String getRelativePath(String groupId, String artifactId, String version, String classifier, String type, MavenContext mavenContext) {
        String extension;
        block14: {
            block17: {
                block16: {
                    block15: {
                        block13: {
                            if (type != null) break block13;
                            extension = "jar";
                            break block14;
                        }
                        if (!"p2metadata".equals(classifier)) break block15;
                        extension = "xml";
                        break block14;
                    }
                    if (!"p2artifacts".equals(classifier)) break block16;
                    extension = "xml";
                    break block14;
                }
                if (!"root".equals(classifier) && (classifier == null || !classifier.startsWith("root."))) break block17;
                extension = "zip";
                break block14;
            }
            switch (type) {
                case "target": 
                case "jar": 
                case "xml": 
                case "zip": {
                    extension = type;
                    break;
                }
                default: {
                    extension = mavenContext.getExtension(type);
                }
            }
        }
        return RepositoryLayoutHelper.getRelativePath(groupId, artifactId, version, classifier, extension);
    }

    public static String getRelativePath(String groupId, String artifactId, String version, String classifier, String extension) {
        Objects.requireNonNull(extension);
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(groupId, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken()).append('/');
        }
        sb.append(artifactId).append('/').append(version).append('/');
        sb.append(artifactId).append('-').append(version);
        if (classifier != null && !classifier.isEmpty()) {
            sb.append('-').append(classifier);
        }
        sb.append('.').append(extension);
        return sb.toString();
    }

    public static GAV getP2Gav(String classifier, String id, String version) {
        return new GAV("p2." + classifier, id, version);
    }

    public static GAV getGAV(Map<?, ?> properties) {
        String groupId = (String)properties.get("maven-groupId");
        String artifactId = (String)properties.get("maven-artifactId");
        String version = (String)properties.get("maven-version");
        return RepositoryLayoutHelper.getGAV(groupId, artifactId, version);
    }

    public static GAV getGAV(String groupId, String artifactId, String version) {
        if (groupId != null && artifactId != null && version != null) {
            return new GAV(groupId, artifactId, version);
        }
        return null;
    }

    public static String getClassifier(Map<?, ?> properties) {
        if (properties == null) {
            return null;
        }
        return (String)properties.get("maven-classifier");
    }

    public static String getType(Map<?, ?> properties) {
        if (properties == null) {
            return null;
        }
        String type = (String)properties.get("maven-type");
        if (type == null) {
            type = (String)properties.get("maven-extension");
        }
        return type;
    }
}

