/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.util.Objects;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;

public final class MavenRepositoryCoordinates {
    private static final String DEFAULT_TYPE = "jar";
    private final GAV gav;
    private final String classifier;
    private final String type;

    public MavenRepositoryCoordinates(GAV gav, String classifier, String type) {
        this.gav = gav;
        this.classifier = classifier;
        this.type = DEFAULT_TYPE.equals(type) ? null : type;
    }

    public MavenRepositoryCoordinates(String groupId, String artifactId, String version, String classifier, String type) {
        this(new GAV(groupId, artifactId, version), classifier, type);
    }

    public GAV getGav() {
        return this.gav;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public String getLocalRepositoryPath(MavenContext mavenContext) {
        return RepositoryLayoutHelper.getRelativePath(this.getGav(), this.getClassifier(), this.getType(), mavenContext);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getGroupId());
        result.append(':');
        result.append(this.getArtifactId());
        result.append(':');
        result.append(Objects.requireNonNullElse(this.getType(), DEFAULT_TYPE));
        if (this.getClassifier() != null) {
            result.append(':');
            result.append(this.getClassifier());
        }
        result.append(':');
        result.append(this.getVersion());
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gav == null ? 0 : this.gav.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenRepositoryCoordinates)) {
            return false;
        }
        MavenRepositoryCoordinates other = (MavenRepositoryCoordinates)obj;
        return MavenRepositoryCoordinates.eq(this.gav, other.gav) && MavenRepositoryCoordinates.eq(this.classifier, other.classifier) && MavenRepositoryCoordinates.eq(this.type, other.type);
    }

    private static <T> boolean eq(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }
}

