/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.facade;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tycho.core.shared.MavenArtifactRepositoryReference;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TargetDefinitionFile
implements TargetDefinition {
    private static final Map<URI, TargetDefinitionFile> FILE_CACHE = new ConcurrentHashMap<URI, TargetDefinitionFile>();
    private final String origin;
    private final byte[] fileContentHash;
    private final Element dom;
    private final Document document;

    private static String getTextFromChild(Element dom, String childName, String defaultValue) {
        Iterator<Element> iterator = TargetDefinitionFile.getChildren(dom, childName).iterator();
        if (iterator.hasNext()) {
            Element element = iterator.next();
            return element.getTextContent();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new TargetDefinitionSyntaxException("Missing child element '" + childName + "'");
    }

    private static List<Element> getChildren(Element element, String tagName) {
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        List nodes = IntStream.range(0, length).mapToObj(item -> list.item(item)).collect(Collectors.toList());
        return nodes.stream().filter(Element.class::isInstance).map(Element.class::cast).filter(e -> e.getNodeName().equals(tagName)).collect(Collectors.toList());
    }

    private static Element getChild(Element element, String tagName) {
        List<Element> list = TargetDefinitionFile.getChildren(element, tagName);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static String getKey(IArtifactFacade artifact) {
        if (artifact == null) {
            return "";
        }
        String key = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId();
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isBlank()) {
            key = String.valueOf(key) + ":" + classifier;
        }
        key = String.valueOf(key) + ":" + artifact.getVersion();
        return key;
    }

    private TargetDefinitionFile(URI uri) throws TargetDefinitionSyntaxException {
        try {
            this.origin = uri.toASCIIString();
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (DigestInputStream input = new DigestInputStream(uri.toURL().openStream(), TargetDefinitionFile.newMD5Digest());){
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    this.document = builder.parse(input);
                    this.dom = this.document.getDocumentElement();
                    this.fileContentHash = input.getMessageDigest().digest();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ParserConfigurationException e) {
                throw new TargetDefinitionSyntaxException("No valid XML parser: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new TargetDefinitionSyntaxException("Target definition is not well-formed XML: " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new TargetDefinitionSyntaxException("I/O error while reading target definition file: " + e.getMessage(), e);
        }
    }

    @Override
    public List<? extends TargetDefinition.Location> getLocations() {
        ArrayList<TargetDefinition.Location> locations = new ArrayList<TargetDefinition.Location>();
        Element locationsDom = TargetDefinitionFile.getChild(this.dom, "locations");
        if (locationsDom != null) {
            for (Element locationDom : TargetDefinitionFile.getChildren(locationsDom, "location")) {
                String type = locationDom.getAttribute("type");
                if ("InstallableUnit".equals(type)) {
                    locations.add(new IULocation(locationDom));
                    continue;
                }
                if ("Directory".equals(type)) {
                    locations.add(new DirectoryTargetLocation(locationDom.getAttribute("path")));
                    continue;
                }
                if ("Profile".equals(type)) {
                    locations.add(new ProfileTargetPlatformLocation(locationDom.getAttribute("path")));
                    continue;
                }
                if ("Feature".equals(type)) {
                    locations.add(new FeatureTargetPlatformLocation(locationDom.getAttribute("path"), locationDom.getAttribute("id"), locationDom.getAttribute("version")));
                    continue;
                }
                if ("Maven".equals(type)) {
                    locations.add(new MavenLocation(locationDom));
                    continue;
                }
                if ("Target".equals(type)) {
                    locations.add(new TargetRef(locationDom.getAttribute("uri")));
                    continue;
                }
                locations.add(new OtherLocation(type));
            }
        }
        return Collections.unmodifiableList(locations);
    }

    @Override
    public boolean hasIncludedBundles() {
        return TargetDefinitionFile.getChild(this.dom, "includeBundles") != null;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    public static TargetDefinitionFile read(File file) {
        return TargetDefinitionFile.read(file.toURI());
    }

    public static TargetDefinitionFile read(URI uri) {
        try {
            return FILE_CACHE.computeIfAbsent(uri, key -> new TargetDefinitionFile((URI)key));
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new RuntimeException("Invalid syntax in target definition " + uri + ": " + e.getMessage(), e);
        }
    }

    public static void write(TargetDefinitionFile target, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(target.document);
                StreamResult result = new StreamResult(new FileOutputStream(file));
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fileContentHash);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetDefinitionFile)) {
            return false;
        }
        TargetDefinitionFile other = (TargetDefinitionFile)obj;
        return Arrays.equals(this.fileContentHash, other.fileContentHash);
    }

    private static MessageDigest newMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTargetEE() {
        Attr path;
        Element targetJRE = TargetDefinitionFile.getChild(this.dom, "targetJRE");
        if (targetJRE != null && (path = targetJRE.getAttributeNode("path")) != null) {
            String pathValue = path.getValue();
            return pathValue.substring(pathValue.lastIndexOf(47) + 1);
        }
        return null;
    }

    public String toString() {
        return "TargetDefinitionFile[" + this.origin + "]";
    }

    private abstract class AbstractPathLocation
    implements TargetDefinition.PathLocation {
        private String path;

        public AbstractPathLocation(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public class DirectoryTargetLocation
    extends AbstractPathLocation
    implements TargetDefinition.DirectoryLocation {
        public DirectoryTargetLocation(String path) {
            super(path);
        }

        @Override
        public String getTypeDescription() {
            return "Directory";
        }
    }

    public class FeatureTargetPlatformLocation
    extends AbstractPathLocation
    implements TargetDefinition.FeaturesLocation {
        private final String feature;
        private final String version;

        public FeatureTargetPlatformLocation(String path, String feature, String version) {
            super(path);
            this.feature = feature;
            this.version = version;
        }

        @Override
        public String getTypeDescription() {
            return "Feature";
        }

        @Override
        public String getId() {
            return this.feature;
        }

        @Override
        public String getVersion() {
            return this.version;
        }
    }

    public class IULocation
    implements TargetDefinition.InstallableUnitLocation {
        private final Element dom;

        public IULocation(Element dom) {
            this.dom = dom;
        }

        @Override
        public List<? extends TargetDefinition.Unit> getUnits() {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Element unitDom : TargetDefinitionFile.getChildren(this.dom, "unit")) {
                units.add(new Unit(unitDom));
            }
            return Collections.unmodifiableList(units);
        }

        @Override
        public List<? extends TargetDefinition.Repository> getRepositories() {
            return this.getRepositoryImpls();
        }

        public List<Repository> getRepositoryImpls() {
            List<Element> repositoryNodes = TargetDefinitionFile.getChildren(this.dom, "repository");
            ArrayList<Repository> repositories = new ArrayList<Repository>(repositoryNodes.size());
            for (Element node : repositoryNodes) {
                repositories.add(new Repository(node));
            }
            return repositories;
        }

        @Override
        public String getTypeDescription() {
            return this.dom.getAttribute("type");
        }

        @Override
        public TargetDefinition.IncludeMode getIncludeMode() {
            Attr attributeValue = this.dom.getAttributeNode("includeMode");
            if (attributeValue == null || "planner".equals(attributeValue.getTextContent())) {
                return TargetDefinition.IncludeMode.PLANNER;
            }
            if ("slicer".equals(attributeValue.getTextContent())) {
                return TargetDefinition.IncludeMode.SLICER;
            }
            throw new TargetDefinitionSyntaxException("Invalid value for attribute 'includeMode': " + attributeValue);
        }

        @Override
        public boolean includeAllEnvironments() {
            return Boolean.parseBoolean(this.dom.getAttribute("includeAllPlatforms"));
        }

        @Override
        public boolean includeSource() {
            return Boolean.parseBoolean(this.dom.getAttribute("includeSource"));
        }
    }

    private static final class MavenDependencyRoot
    implements TargetDefinition.MavenDependency {
        private Element dom;
        private MavenLocation parent;

        public MavenDependencyRoot(Element dom, MavenLocation parent) {
            this.dom = dom;
            this.parent = parent;
        }

        @Override
        public String getGroupId() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "groupId", null);
        }

        @Override
        public String getArtifactId() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "artifactId", null);
        }

        @Override
        public String getVersion() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "version", null);
        }

        @Override
        public String getArtifactType() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "type", "jar");
        }

        @Override
        public String getClassifier() {
            return TargetDefinitionFile.getTextFromChild(this.dom, "classifier", "");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupId = ");
            builder.append(this.getGroupId());
            builder.append(", ArtifactId = ");
            builder.append(this.getArtifactId());
            builder.append(", Version = ");
            builder.append(this.getVersion());
            builder.append(", ArtifactType = ");
            builder.append(this.getArtifactType());
            builder.append(", IncludeDependencyScope = ");
            return builder.toString();
        }

        @Override
        public boolean isIgnored(IArtifactFacade artifact) {
            return this.parent.globalExcludes.contains(TargetDefinitionFile.getKey(artifact));
        }
    }

    public class MavenLocation
    implements TargetDefinition.MavenGAVLocation {
        private Element dom;
        private Set<String> globalExcludes = new HashSet<String>();

        public MavenLocation(Element dom) {
            this.dom = dom;
            List<Element> children = TargetDefinitionFile.getChildren(dom, "exclude");
            for (Element element : children) {
                this.globalExcludes.add(element.getTextContent());
            }
        }

        @Override
        public String getTypeDescription() {
            return "Maven";
        }

        @Override
        public String getIncludeDependencyScope() {
            return this.dom.getAttribute("includeDependencyScope");
        }

        @Override
        public TargetDefinition.MavenGAVLocation.MissingManifestStrategy getMissingManifestStrategy() {
            String attributeValue = this.dom.getAttribute("missingManifest");
            if ("generate".equalsIgnoreCase(attributeValue)) {
                return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.GENERATE;
            }
            if ("ignore".equals(attributeValue)) {
                return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.IGNORE;
            }
            return TargetDefinition.MavenGAVLocation.MissingManifestStrategy.ERROR;
        }

        @Override
        public boolean includeSource() {
            return Boolean.parseBoolean(this.dom.getAttribute("includeSource"));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MavenDependencyRoots = ");
            builder.append(this.getRoots());
            builder.append(", IncludeDependencyScope = ");
            builder.append(this.getIncludeDependencyScope());
            builder.append(", MissingManifestStrategy = ");
            builder.append((Object)this.getMissingManifestStrategy());
            builder.append(", IncludeSource = ");
            builder.append(this.includeSource());
            return builder.toString();
        }

        @Override
        public Collection<TargetDefinition.BNDInstructions> getInstructions() {
            ArrayList<TargetDefinition.BNDInstructions> list = new ArrayList<TargetDefinition.BNDInstructions>();
            for (Element element : TargetDefinitionFile.getChildren(this.dom, "instructions")) {
                final String reference = element.getAttribute("reference");
                String text = element.getTextContent();
                final Properties properties = new Properties();
                try {
                    properties.load(new StringReader(text));
                }
                catch (IOException e) {
                    throw new TargetDefinitionSyntaxException("parsing instructions into properties failed", e);
                }
                list.add(new TargetDefinition.BNDInstructions(){

                    @Override
                    public String getReference() {
                        if (reference == null) {
                            return "";
                        }
                        return reference;
                    }

                    @Override
                    public Properties getInstructions() {
                        return properties;
                    }
                });
            }
            return list;
        }

        @Override
        public Collection<TargetDefinition.MavenDependency> getRoots() {
            Iterator<Element> iterator = TargetDefinitionFile.getChildren(this.dom, "dependencies").iterator();
            if (iterator.hasNext()) {
                Element dependencies = iterator.next();
                ArrayList<TargetDefinition.MavenDependency> roots = new ArrayList<TargetDefinition.MavenDependency>();
                for (Element dependency : TargetDefinitionFile.getChildren(dependencies, "dependency")) {
                    roots.add(new MavenDependencyRoot(dependency, this));
                }
                return roots;
            }
            return Collections.singleton(new MavenDependencyRoot(this.dom, this));
        }

        @Override
        public Collection<MavenArtifactRepositoryReference> getRepositoryReferences() {
            Iterator<Element> iterator = TargetDefinitionFile.getChildren(this.dom, "repositories").iterator();
            if (iterator.hasNext()) {
                Element dependencies = iterator.next();
                ArrayList<MavenArtifactRepositoryReference> list = new ArrayList<MavenArtifactRepositoryReference>();
                for (final Element repository : TargetDefinitionFile.getChildren(dependencies, "repository")) {
                    list.add(new MavenArtifactRepositoryReference(){

                        public String getId() {
                            return TargetDefinitionFile.getTextFromChild(repository, "id", String.valueOf(System.identityHashCode(repository)));
                        }

                        public String getUrl() {
                            return TargetDefinitionFile.getTextFromChild(repository, "url", null);
                        }
                    });
                }
                return list;
            }
            return Collections.emptyList();
        }

        @Override
        public Element getFeatureTemplate() {
            return TargetDefinitionFile.getChild(this.dom, "feature");
        }

        @Override
        public TargetDefinition.MavenGAVLocation.DependencyDepth getIncludeDependencyDepth() {
            if (this.dom.getAttributeNode("includeDependencyDepth") == null) {
                String scope = this.getIncludeDependencyScope();
                if (scope == null || scope.isBlank()) {
                    return TargetDefinition.MavenGAVLocation.DependencyDepth.NONE;
                }
                return TargetDefinition.MavenGAVLocation.DependencyDepth.INFINITE;
            }
            String attribute = this.dom.getAttribute("includeDependencyDepth");
            if ("NONE".equalsIgnoreCase(attribute)) {
                return TargetDefinition.MavenGAVLocation.DependencyDepth.NONE;
            }
            if ("DIRECT".equalsIgnoreCase(attribute)) {
                return TargetDefinition.MavenGAVLocation.DependencyDepth.DIRECT;
            }
            if ("INFINITE".equalsIgnoreCase(attribute)) {
                return TargetDefinition.MavenGAVLocation.DependencyDepth.INFINITE;
            }
            return TargetDefinition.MavenGAVLocation.DependencyDepth.NONE;
        }
    }

    public static class OtherLocation
    implements TargetDefinition.Location {
        private final String description;

        public OtherLocation(String description) {
            this.description = description;
        }

        @Override
        public String getTypeDescription() {
            return this.description;
        }
    }

    public class ProfileTargetPlatformLocation
    extends AbstractPathLocation
    implements TargetDefinition.ProfileLocation {
        public ProfileTargetPlatformLocation(String path) {
            super(path);
        }

        @Override
        public String getTypeDescription() {
            return "Profile";
        }
    }

    public static final class Repository
    implements TargetDefinition.Repository {
        private final Element dom;

        public Repository(Element dom) {
            this.dom = dom;
        }

        @Override
        public String getId() {
            return this.dom.getAttribute("id");
        }

        @Override
        public URI getLocation() {
            try {
                return new URI(this.dom.getAttribute("location"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Deprecated
        public void setLocation(String location) {
            this.dom.setAttribute("location", location);
        }
    }

    public class TargetRef
    implements TargetDefinition.TargetReferenceLocation {
        private String uri;
        private URI resolvedUri;

        public TargetRef(String uri) {
            this.uri = uri;
        }

        @Override
        public String getTypeDescription() {
            return "Target";
        }

        @Override
        public String getUri() {
            return this.uri;
        }
    }

    public static class Unit
    implements TargetDefinition.Unit {
        private final Element dom;

        public Unit(Element dom) {
            this.dom = dom;
        }

        @Override
        public String getId() {
            return this.dom.getAttribute("id");
        }

        @Override
        public String getVersion() {
            return this.dom.getAttribute("version");
        }

        @Deprecated
        public void setVersion(String version) {
            this.dom.setAttribute("version", version);
        }
    }
}

