/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredPropertiesMatch;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.target.ee.NoExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolverDebugUtils;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.p2base.metadata.QueryableCollection;
import org.eclipse.tycho.repository.util.StatusTool;

abstract class AbstractSlicerResolutionStrategy
extends AbstractResolutionStrategy {
    protected AbstractSlicerResolutionStrategy(MavenLogger logger) {
        super(logger);
    }

    protected final IQueryable<IInstallableUnit> slice(Map<String, String> properties, IProgressMonitor monitor) throws ResolverException {
        return this.slice(properties, Collections.emptyList(), monitor);
    }

    protected final IQueryable<IInstallableUnit> slice(Map<String, String> properties, List<IInstallableUnit> additionalUnits, IProgressMonitor monitor) throws ResolverException {
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Properties: " + properties.toString());
            this.logger.debug("Available IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getAvailableIUs(), false));
            this.logger.debug("JRE IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getEEResolutionHints().getMandatoryUnits(), false));
            this.logger.debug("Root IUs:\n" + ResolverDebugUtils.toDebugString(this.data.getRootIUs(), true));
            if (this.data.getAdditionalRequirements() != null && !this.data.getAdditionalRequirements().isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (IRequirement req : this.data.getAdditionalRequirements()) {
                    sb.append("   ").append(req.toString()).append("\n");
                }
                this.logger.debug("Extra Requirements:\n" + sb.toString());
            }
        }
        LinkedHashSet<IInstallableUnit> availableIUs = new LinkedHashSet<IInstallableUnit>(this.data.getAvailableIUs());
        availableIUs.addAll(this.data.getEEResolutionHints().getTemporaryAdditions());
        availableIUs.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        availableIUs.addAll(additionalUnits);
        LinkedHashSet<IInstallableUnit> seedIUs = new LinkedHashSet<IInstallableUnit>(this.data.getRootIUs());
        if (this.data.getAdditionalRequirements() != null && !this.data.getAdditionalRequirements().isEmpty()) {
            seedIUs.add(AbstractSlicerResolutionStrategy.createUnitRequiring("tycho-extra", null, this.data.getAdditionalRequirements()));
        }
        seedIUs.addAll(this.data.getEEResolutionHints().getMandatoryUnits());
        if (!this.data.getEEResolutionHints().getMandatoryRequires().isEmpty()) {
            seedIUs.add(AbstractSlicerResolutionStrategy.createUnitRequiring("tycho-ee", null, this.data.getEEResolutionHints().getMandatoryRequires()));
        }
        Slicer slicer = this.newSlicer((IQueryable<IInstallableUnit>)new QueryableCollection(availableIUs), properties);
        IQueryable slice = slicer.slice(seedIUs.toArray(EMPTY_IU_ARRAY), monitor);
        MultiStatus slicerStatus = slicer.getStatus();
        if (slice == null || this.isSlicerError(slicerStatus)) {
            throw new ResolverException(StatusTool.toLogMessage((IStatus)slicerStatus), properties.toString(), StatusTool.findException((IStatus)slicerStatus));
        }
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Slice:\n" + ResolverDebugUtils.toDebugString((IQueryable<IInstallableUnit>)slice, false, monitor));
        }
        return slice;
    }

    protected abstract boolean isSlicerError(MultiStatus var1);

    protected abstract Slicer newSlicer(IQueryable<IInstallableUnit> var1, Map<String, String> var2);

    protected static IInstallableUnit createUnitRequiring(String name, Collection<IInstallableUnit> units, Collection<IRequirement> additionalRequirements) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        result.setId(String.valueOf(name) + "-" + time);
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        if (units != null) {
            for (IInstallableUnit unit : units) {
                requirements.add(AbstractSlicerResolutionStrategy.createStrictRequirementTo(unit));
            }
        }
        if (additionalRequirements != null) {
            requirements.addAll(additionalRequirements);
        }
        result.addRequirements(requirements);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }

    protected IInstallableUnit createUnitProviding(String name, Collection<IRequirement> requirements) {
        MetadataFactory.InstallableUnitDescription result = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        result.setId(String.valueOf(name) + "-" + UUID.randomUUID());
        result.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        for (IRequirement requirement : requirements) {
            if (requirement instanceof IRequiredCapability) {
                try {
                    IRequiredCapability capability = (IRequiredCapability)requirement;
                    String namespace = capability.getNamespace();
                    IMatchExpression matches = capability.getMatches();
                    String extractName = RequiredCapability.extractName((IMatchExpression)matches);
                    Version version = RequiredCapability.extractRange((IMatchExpression)matches).getMinimum();
                    IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)namespace, (String)extractName, (Version)version);
                    result.addProvidedCapabilities(Collections.singleton(providedCapability));
                }
                catch (RuntimeException e) {
                    this.logger.debug("can't convert requirement " + requirement + " to capability: " + e.toString(), (Throwable)e);
                }
                continue;
            }
            if (!(requirement instanceof RequiredPropertiesMatch)) continue;
            try {
                if (!AbstractSlicerResolutionStrategy.isEERequirement(requirement)) continue;
                RequiredPropertiesMatch propertiesMatch = (RequiredPropertiesMatch)requirement;
                IMatchExpression matches = propertiesMatch.getMatches();
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Object p = matches.getParameters()[1];
                if (p instanceof IExpression) {
                    IExpression[] operands;
                    IExpression expression = (IExpression)p;
                    IExpression operand = ExpressionUtil.getOperand((IExpression)expression);
                    IExpression[] iExpressionArray = operands = ExpressionUtil.getOperands((IExpression)operand);
                    int n = operands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExpression eq = iExpressionArray[n2];
                        IExpression lhs = ExpressionUtil.getLHS((IExpression)eq);
                        IExpression rhs = ExpressionUtil.getRHS((IExpression)eq);
                        Object value = ExpressionUtil.getValue((IExpression)rhs);
                        String key = ExpressionUtil.getName((IExpression)lhs);
                        if ("version".equals(key)) {
                            properties.put(key, Version.create((String)value.toString()));
                        } else {
                            properties.put(key, value.toString());
                        }
                        ++n2;
                    }
                }
                IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)RequiredPropertiesMatch.extractNamespace((IMatchExpression)matches), properties);
                result.addProvidedCapabilities(Collections.singleton(providedCapability));
            }
            catch (RuntimeException e) {
                this.logger.debug("can't convert requirement " + requirement + " to capability: " + e.toString(), (Throwable)e);
            }
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)result);
    }

    protected List<IRequirement> computeMissingRequirements(Set<Explanation> explanation) {
        ArrayList<IRequirement> missingRequirements = new ArrayList<IRequirement>();
        HashSet<IInstallableUnit> availableIUs = new HashSet<IInstallableUnit>(this.data.getAvailableIUs());
        for (Explanation exp : explanation) {
            if (exp instanceof Explanation.IUToInstall) {
                Explanation.IUToInstall iuToInstall = (Explanation.IUToInstall)exp;
                availableIUs.add(iuToInstall.iu);
                continue;
            }
            if (exp instanceof Explanation.MissingIU) {
                Explanation.MissingIU missingIU = (Explanation.MissingIU)exp;
                availableIUs.add(missingIU.iu);
                if (AbstractSlicerResolutionStrategy.isEERequirement(missingIU.req)) {
                    if (!(this.data.getEEResolutionHints() instanceof NoExecutionEnvironmentResolutionHints)) continue;
                    missingRequirements.add(missingIU.req);
                    continue;
                }
                for (IInstallableUnit available : availableIUs) {
                    if (!missingIU.req.isMatch(available)) continue;
                    if (this.logger.isExtendedDebugEnabled()) {
                        this.logger.debug("IU " + missingIU.iu + " requires an available or incomplete IU " + available + " ...");
                    }
                    return missingRequirements;
                }
                if (this.data.failOnMissingRequirements()) continue;
                missingRequirements.add(missingIU.req);
                continue;
            }
            if (exp instanceof Explanation.HardRequirement) {
                Explanation.HardRequirement hardRequirement = (Explanation.HardRequirement)exp;
                availableIUs.add(hardRequirement.iu);
                for (IInstallableUnit available : availableIUs) {
                    if (!hardRequirement.req.isMatch(available)) continue;
                    if (this.logger.isExtendedDebugEnabled()) {
                        this.logger.debug("IU " + hardRequirement.iu + " has requirement on available or incomplete IU " + available + " ...");
                    }
                    return missingRequirements;
                }
                missingRequirements.add(hardRequirement.req);
                continue;
            }
            if (!this.logger.isExtendedDebugEnabled()) continue;
            this.logger.debug("Ignoring Explanation of type " + exp.getClass() + " in computation of missing requirements: " + exp);
        }
        missingRequirements.forEach(this.data::addMissingRequirement);
        return missingRequirements;
    }

    protected static boolean isEERequirement(IRequirement requirement) {
        if (requirement instanceof RequiredPropertiesMatch) {
            RequiredPropertiesMatch propertiesMatch = (RequiredPropertiesMatch)requirement;
            String namespace = RequiredPropertiesMatch.extractNamespace((IMatchExpression)propertiesMatch.getMatches());
            return "osgi.ee".equals(namespace);
        }
        return false;
    }

    private static IRequirement createStrictRequirementTo(IInstallableUnit unit) {
        VersionRange strictRange = new VersionRange(unit.getVersion(), true, unit.getVersion(), true);
        int min = 1;
        int max = Integer.MAX_VALUE;
        boolean greedy = true;
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)unit.getId(), (VersionRange)strictRange, (IMatchExpression)unit.getFilter(), (int)min, (int)max, (boolean)greedy);
        return requirement;
    }
}

