/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target.repository;

import java.io.File;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;
import org.eclipse.tycho.repository.local.GAVArtifactDescriptor;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicies;
import org.eclipse.tycho.repository.p2base.artifact.repository.ArtifactRepositoryBaseImpl;

public final class MavenBundlesArtifactRepository
extends ArtifactRepositoryBaseImpl<GAVArtifactDescriptor> {
    private MavenContext mavenContext;

    public MavenBundlesArtifactRepository(MavenContext mavenContext) {
        super(null, mavenContext.getLocalRepositoryRoot().toURI(), ArtifactTransferPolicies.forLocalArtifacts());
        this.mavenContext = mavenContext;
    }

    public void addPublishedArtifact(IArtifactDescriptor baseDescriptor, IArtifactFacade mavenArtifact) {
        File actualArtifactLocation;
        MavenRepositoryCoordinates repositoryCoordinates = new MavenRepositoryCoordinates(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), mavenArtifact.getClassifier(), null);
        GAVArtifactDescriptor descriptorForRepository = new GAVArtifactDescriptor(baseDescriptor, repositoryCoordinates);
        MavenRepositoryCoordinates mavenCoordinates = descriptorForRepository.getMavenCoordinates();
        File baseDir = this.getBaseDir();
        File requiredArtifactLocation = new File(baseDir, mavenCoordinates.getLocalRepositoryPath(this.mavenContext));
        if (!this.equivalentPaths(requiredArtifactLocation, actualArtifactLocation = mavenArtifact.getLocation())) {
            throw new AssertionFailedException("The Maven artifact to be added to the target platform is not stored at the required location on disk: required \"" + requiredArtifactLocation + "\" but was \"" + actualArtifactLocation + "\"");
        }
        this.internalAddInternalDescriptor((IArtifactDescriptor)descriptorForRepository);
    }

    private boolean equivalentPaths(File path, File otherPath) {
        return path.equals(otherPath);
    }

    protected GAVArtifactDescriptor getInternalDescriptorForAdding(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    protected IArtifactDescriptor getComparableDescriptor(IArtifactDescriptor descriptor) {
        return this.toInternalDescriptor(descriptor);
    }

    private GAVArtifactDescriptor toInternalDescriptor(IArtifactDescriptor descriptor) {
        if (descriptor instanceof GAVArtifactDescriptor && descriptor.getRepository() == this) {
            return (GAVArtifactDescriptor)descriptor;
        }
        GAVArtifactDescriptor internalDescriptor = new GAVArtifactDescriptor(descriptor);
        internalDescriptor.setRepository((IArtifactRepository)this);
        return internalDescriptor;
    }

    protected File internalGetArtifactStorageLocation(IArtifactDescriptor descriptor) {
        String relativePath = this.toInternalDescriptor(descriptor).getMavenCoordinates().getLocalRepositoryPath(this.mavenContext);
        return new File(this.getBaseDir(), relativePath);
    }

    public File getBaseDir() {
        return new File(this.getLocation());
    }

    public boolean isFileAlreadyAvailable(IArtifactKey artifact) {
        return this.contains(artifact);
    }
}

