/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.BuildFailureException;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.core.resolver.shared.IncludeSourceMode;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.core.shared.MavenDependenciesResolver;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.p2.resolver.FileTargetDefinitionContent;
import org.eclipse.tycho.p2.resolver.InstallableUnitResolver;
import org.eclipse.tycho.p2.resolver.MavenTargetDefinitionContent;
import org.eclipse.tycho.p2.resolver.URITargetDefinitionContent;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionFile;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.p2base.artifact.repository.ListCompositeArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.repository.ListCompositeMetadataRepository;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;

public final class TargetDefinitionResolver {
    private static final Pattern SYSTEM_PROPERTY_PATTERN = TargetDefinitionResolver.createVariablePatternArgument("system_property");
    private static final Pattern PROJECT_LOC_PATTERN = TargetDefinitionResolver.createVariablePatternArgument("project_loc");
    private static final Pattern ENV_VAR_PATTERN = TargetDefinitionResolver.createVariablePatternArgument("env_var");
    private final MavenLogger logger;
    private final List<TargetEnvironment> environments;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private MavenContext mavenContext;
    private IncludeSourceMode includeSourceMode;
    private MavenDependenciesResolver mavenDependenciesResolver;

    public TargetDefinitionResolver(List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints executionEnvironment, IncludeSourceMode includeSourceMode, MavenContext mavenContext, MavenDependenciesResolver mavenDependenciesResolver) {
        this.environments = environments;
        this.executionEnvironment = executionEnvironment;
        this.includeSourceMode = includeSourceMode;
        this.mavenContext = mavenContext;
        this.mavenDependenciesResolver = mavenDependenciesResolver;
        this.logger = mavenContext.getLogger();
    }

    public TargetDefinitionContent resolveContent(TargetDefinition definition, IProvisioningAgent provisioningAgent) {
        try {
            return this.resolveContentWithExceptions(definition, provisioningAgent);
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new BuildFailureException("Invalid syntax in target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (TargetDefinitionResolutionException e) {
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (ResolverException e) {
            this.logResolverException(e);
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin(), (Throwable)e);
        }
    }

    private void logResolverException(ResolverException e) {
        this.logger.error("Cannot resolve target definition:");
        new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
        this.logger.error("");
    }

    TargetDefinitionContent resolveContentWithExceptions(TargetDefinition definition, final IProvisioningAgent provisioningAgent) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException, ResolverException {
        final Collector unitResultSet = new Collector();
        InstallableUnitResolver installableUnitResolver = null;
        LinkedHashMap<String, FileTargetDefinitionContent> fileRepositories = new LinkedHashMap<String, FileTargetDefinitionContent>();
        LinkedHashMap<String, URITargetDefinitionContent> uriRepositories = new LinkedHashMap<String, URITargetDefinitionContent>();
        ArrayList<MavenTargetDefinitionContent> mavenLocations = new ArrayList<MavenTargetDefinitionContent>();
        ArrayList<TargetDefinitionContent> referencedTargetLocations = new ArrayList<TargetDefinitionContent>();
        for (TargetDefinition.Location locationDefinition : definition.getLocations()) {
            String resolvePath;
            String key2;
            if (locationDefinition instanceof TargetDefinition.InstallableUnitLocation) {
                TargetDefinition.InstallableUnitLocation installableUnitLocation = (TargetDefinition.InstallableUnitLocation)locationDefinition;
                if (installableUnitResolver == null) {
                    installableUnitResolver = new InstallableUnitResolver(this.environments, this.executionEnvironment, this.includeSourceMode, this.logger);
                }
                ArrayList<URITargetDefinitionContent> locations = new ArrayList<URITargetDefinitionContent>();
                for (TargetDefinition.Repository repository : installableUnitLocation.getRepositories()) {
                    URI location = repository.getLocation();
                    key2 = location.normalize().toASCIIString();
                    locations.add(uriRepositories.computeIfAbsent(key2, s -> new URITargetDefinitionContent(provisioningAgent, location, repository.getId())));
                }
                IQueryable locationUnits = QueryUtil.compoundQueryable(locations);
                installableUnitResolver.addLocation((TargetDefinition.InstallableUnitLocation)locationDefinition, (IQueryable<IInstallableUnit>)locationUnits);
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.PathLocation) {
                File fileLocation;
                TargetDefinition.PathLocation pathLocation = (TargetDefinition.PathLocation)locationDefinition;
                resolvePath = this.resolvePath(pathLocation.getPath(), definition);
                try {
                    fileLocation = new File(resolvePath).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new ResolverException("I/O Error while resolving path " + resolvePath, e);
                }
                if (fileLocation.exists()) {
                    FileTargetDefinitionContent fileRepositoryRolver = fileRepositories.computeIfAbsent(fileLocation.getAbsolutePath(), key -> new FileTargetDefinitionContent(provisioningAgent, fileLocation));
                    if (pathLocation instanceof TargetDefinition.DirectoryLocation || pathLocation instanceof TargetDefinition.ProfileLocation) {
                        unitResultSet.addAll(fileRepositoryRolver.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger)));
                        continue;
                    }
                    if (!(pathLocation instanceof TargetDefinition.FeaturesLocation)) continue;
                    TargetDefinition.FeaturesLocation featuresLocation = (TargetDefinition.FeaturesLocation)pathLocation;
                    key2 = FeaturesAction.createFeatureArtifactKey((String)featuresLocation.getId(), (String)featuresLocation.getVersion());
                    unitResultSet.addAll(fileRepositoryRolver.query((IQuery<IInstallableUnit>)QueryUtil.createIUQuery((IVersionedId)key2), (IProgressMonitor)new LoggingProgressMonitor(this.logger)));
                    continue;
                }
                this.logger.warn("Target location path '" + fileLocation.getAbsolutePath() + "' does not exist, target resolution might be incomplete.");
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.MavenGAVLocation) {
                TargetDefinition.MavenGAVLocation location = (TargetDefinition.MavenGAVLocation)locationDefinition;
                MavenTargetDefinitionContent targetDefinitionContent = new MavenTargetDefinitionContent(location, this.mavenDependenciesResolver, this.includeSourceMode, provisioningAgent, this.mavenContext);
                mavenLocations.add(targetDefinitionContent);
                IQueryResult<IInstallableUnit> result = targetDefinitionContent.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger));
                unitResultSet.addAll(result);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("The following artifacts where resolved from location " + location);
                for (IInstallableUnit iu : result.toUnmodifiableSet()) {
                    this.logger.debug("\t" + iu);
                }
                continue;
            }
            if (locationDefinition instanceof TargetDefinition.TargetReferenceLocation) {
                URI resolvedUri;
                TargetDefinition.TargetReferenceLocation referenceLocation = (TargetDefinition.TargetReferenceLocation)locationDefinition;
                this.logger.info("Resolving " + referenceLocation.getUri());
                resolvePath = this.resolvePath(referenceLocation.getUri(), definition);
                try {
                    resolvedUri = new URI(TargetDefinitionResolver.convertRawToUri(resolvePath));
                }
                catch (URISyntaxException e) {
                    throw new ResolverException("Invalid URI " + resolvePath + ": " + e.getMessage(), e);
                }
                this.logger.info("Reading target " + resolvedUri + "...");
                TargetDefinitionContent content = this.resolveContentWithExceptions((TargetDefinition)TargetDefinitionFile.read((URI)resolvedUri), provisioningAgent);
                IQueryResult<IInstallableUnit> result = content.query((IQuery<IInstallableUnit>)QueryUtil.ALL_UNITS, (IProgressMonitor)new LoggingProgressMonitor(this.logger));
                unitResultSet.addAll(result);
                referencedTargetLocations.add(content);
                continue;
            }
            this.logger.warn("Target location type '" + locationDefinition.getTypeDescription() + "' is not supported");
        }
        if (definition.hasIncludedBundles()) {
            this.logger.warn("De-selecting bundles in a target definition file is not supported. See https://wiki.eclipse.org/Tycho_Messages_Explained#Target_File_Include_Bundles for alternatives.");
        }
        final ArrayList<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
        final ArrayList<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
        for (FileTargetDefinitionContent fileDefinitionContent : fileRepositories.values()) {
            metadataRepositories.add(fileDefinitionContent.getMetadataRepository());
            artifactRepositories.add(fileDefinitionContent.getArtifactRepository());
        }
        for (URITargetDefinitionContent uriDefinitionContent : uriRepositories.values()) {
            metadataRepositories.add(uriDefinitionContent.getMetadataRepository());
            artifactRepositories.add(uriDefinitionContent.getArtifactRepository());
        }
        for (MavenTargetDefinitionContent mavenContent : mavenLocations) {
            metadataRepositories.add(mavenContent.getMetadataRepository());
            artifactRepositories.add(mavenContent.getArtifactRepository());
        }
        for (TargetDefinitionContent referenceContent : referencedTargetLocations) {
            metadataRepositories.add(referenceContent.getMetadataRepository());
            artifactRepositories.add(referenceContent.getArtifactRepository());
        }
        if (installableUnitResolver != null) {
            ListCompositeMetadataRepository metadataRepository = new ListCompositeMetadataRepository(metadataRepositories, provisioningAgent);
            unitResultSet.addAll(installableUnitResolver.resolve((IQueryable<IInstallableUnit>)metadataRepository));
        }
        return new TargetDefinitionContent(){
            private ListCompositeArtifactRepository artifactRepository;
            private IMetadataRepository metadataRepository;

            @Override
            public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return unitResultSet.query(query, monitor);
            }

            @Override
            public IMetadataRepository getMetadataRepository() {
                if (this.metadataRepository == null) {
                    this.metadataRepository = new ListCompositeMetadataRepository(metadataRepositories, provisioningAgent);
                }
                return this.metadataRepository;
            }

            @Override
            public IArtifactRepository getArtifactRepository() {
                if (this.artifactRepository == null) {
                    this.artifactRepository = new ListCompositeArtifactRepository(provisioningAgent, artifactRepositories);
                }
                return this.artifactRepository;
            }
        };
    }

    static String convertRawToUri(String resolvePath) {
        String lc = (resolvePath = resolvePath.replace('\\', '/')).toLowerCase();
        if (lc.startsWith("file:") && !lc.startsWith("file:/")) {
            resolvePath = resolvePath.replaceFirst("(?i)^file:", "file:/");
        }
        return resolvePath;
    }

    protected String resolvePath(String path, TargetDefinition definition) {
        path = TargetDefinitionResolver.resolvePattern(path, SYSTEM_PROPERTY_PATTERN, key -> this.mavenContext.getSessionProperties().getProperty((String)key, ""));
        path = TargetDefinitionResolver.resolvePattern(path, ENV_VAR_PATTERN, key -> {
            String env = System.getenv(key);
            return env == null ? "" : env;
        });
        path = TargetDefinitionResolver.resolvePattern(path, PROJECT_LOC_PATTERN, this::findProjectLocation);
        return path;
    }

    private String findProjectLocation(String projectName) {
        String name;
        if (projectName.startsWith("/")) {
            projectName = projectName.substring(1);
        }
        this.logger.debug("Find project location for project " + projectName);
        for (ReactorProject project : this.mavenContext.getProjects()) {
            name = project.getName();
            this.logger.debug("check reactor project name: " + name);
            if (!name.equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        for (ReactorProject project : this.mavenContext.getProjects()) {
            String artifactId = project.getArtifactId();
            this.logger.debug("check reactor project artifact id: " + artifactId);
            if (!artifactId.equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        for (ReactorProject project : this.mavenContext.getProjects()) {
            name = project.getBasedir().getName();
            this.logger.debug("check reactor project base directory: " + name);
            if (!name.equals(projectName)) continue;
            return project.getBasedir().getAbsolutePath();
        }
        String defaultValue = "${project_loc:" + projectName + "}";
        this.logger.warn("Can't resolve " + defaultValue + " target resoloution might be incomplete");
        return defaultValue;
    }

    private static String resolvePattern(String input, Pattern pattern, Function<String, String> parameterResolver) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group(1);
            String resolved = parameterResolver.apply(group);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(resolved));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Pattern createVariablePatternArgument(String variableName) {
        return Pattern.compile("\\$\\{" + variableName + ":([^}]+)\\}", 2);
    }
}

