/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.remote;

import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.MavenRepositorySettings;
import org.eclipse.tycho.core.shared.MavenContext;
import org.eclipse.tycho.p2.remote.RemoteAgent;

public class RemoteAgentManager {
    private MavenContext mavenContext;
    private MavenRepositorySettings mavenRepositorySettings;
    private IProvisioningAgent cachedAgent;
    private IProxyService proxyService;

    public RemoteAgentManager(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public RemoteAgentManager() {
    }

    public synchronized IProvisioningAgent getProvisioningAgent() throws ProvisionException {
        if (this.cachedAgent == null) {
            boolean disableP2Mirrors = this.getDisableP2MirrorsConfiguration();
            this.cachedAgent = new RemoteAgent(this.mavenContext, this.proxyService, this.mavenRepositorySettings, disableP2Mirrors);
        }
        return this.cachedAgent;
    }

    private boolean getDisableP2MirrorsConfiguration() {
        String key = "tycho.disableP2Mirrors";
        String value = this.mavenContext.getSessionProperties().getProperty(key);
        boolean disableP2Mirrors = Boolean.parseBoolean(value);
        if (disableP2Mirrors && this.mavenContext.getLogger().isDebugEnabled()) {
            String message = String.valueOf(key) + "=" + value + " -> ignoring mirrors specified in p2 artifact repositories";
            this.mavenContext.getLogger().debug(message);
        }
        return disableP2Mirrors;
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setMavenRepositorySettings(MavenRepositorySettings mavenRepositorySettings) {
        this.mavenRepositorySettings = mavenRepositorySettings;
    }

    public void setProxyService(IProxyService proxyService) {
        this.proxyService = proxyService;
    }
}

