/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.BuildProperties;
import org.eclipse.tycho.BuildPropertiesParser;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.Interpolator;
import org.eclipse.tycho.OptionalResolutionAction;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.p2.impl.publisher.DependencyMetadata;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.eclipse.tycho.repository.util.StatusTool;

public abstract class AbstractMetadataGenerator {
    private IProgressMonitor monitor = new NullProgressMonitor();
    private BuildPropertiesParser buildPropertiesParser;

    protected DependencyMetadata generateMetadata(IArtifactFacade artifact, List<TargetEnvironment> environments, PublisherInfo publisherInfo, OptionalResolutionAction optionalAction, PublisherOptions options) {
        for (IPublisherAdvice advice : this.getPublisherAdvice(artifact, options)) {
            publisherInfo.addAdvice(advice);
        }
        List<IPublisherAction> actions = this.getPublisherActions(artifact, environments, optionalAction);
        return this.publish(publisherInfo, actions);
    }

    protected abstract List<IPublisherAction> getPublisherActions(IArtifactFacade var1, List<TargetEnvironment> var2, OptionalResolutionAction var3);

    protected abstract List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade var1, PublisherOptions var2);

    protected ICapabilityAdvice getExtraEntriesAdvice(IArtifactFacade artifact, Interpolator interpolator) {
        final IRequirement[] extraRequirements = this.extractExtraEntriesAsIURequirement(artifact.getLocation(), interpolator);
        return new ICapabilityAdvice(){

            public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
                return true;
            }

            public IRequirement[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return extraRequirements;
            }

            public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return null;
            }

            public IRequirement[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return null;
            }
        };
    }

    private IRequirement[] extractExtraEntriesAsIURequirement(File location, Interpolator interpolator) {
        BuildProperties buildProps = this.buildPropertiesParser.parse(location, interpolator);
        ArrayList<IRequirement> result = new ArrayList<IRequirement>();
        for (Map.Entry entry : buildProps.getJarToExtraClasspathMap().entrySet()) {
            this.createRequirementFromExtraClasspathProperty(result, (List)entry.getValue());
        }
        this.createRequirementFromExtraClasspathProperty(result, buildProps.getJarsExtraClasspath());
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new IRequirement[result.size()]);
    }

    private void createRequirementFromExtraClasspathProperty(ArrayList<IRequirement> result, List<String> urls) {
        for (String url : urls) {
            this.createRequirementFromPlatformURL(result, url);
        }
    }

    private void createRequirementFromPlatformURL(ArrayList<IRequirement> result, String url) {
        Pattern platformURL = Pattern.compile("platform:/(plugin|fragment)/([^/]*)(/)*.*");
        Matcher m = platformURL.matcher(url);
        if (m.matches()) {
            result.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)m.group(2), (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false));
        }
    }

    private DependencyMetadata publish(PublisherInfo publisherInfo, List<IPublisherAction> actions) {
        PublisherResult result = new PublisherResult();
        Publisher publisher = new Publisher((IPublisherInfo)publisherInfo, (IPublisherResult)result);
        IStatus status = publisher.publish(actions.toArray(new IPublisherAction[actions.size()]), this.monitor);
        if (!status.isOK()) {
            throw new RuntimeException(StatusTool.collectProblems((IStatus)status), status.getException());
        }
        DependencyMetadata metadata = new DependencyMetadata();
        metadata.setDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED, result.getIUs(null, "root"));
        metadata.setDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE, result.getIUs(null, "non_root"));
        IArtifactRepository artifactRepository = publisherInfo.getArtifactRepository();
        if (artifactRepository instanceof TransientArtifactRepository) {
            metadata.setArtifacts(((TransientArtifactRepository)artifactRepository).getArtifactDescriptors());
        }
        return metadata;
    }

    public void setBuildPropertiesParser(BuildPropertiesParser buildPropertiesReader) {
        this.buildPropertiesParser = buildPropertiesReader;
    }

    protected BuildPropertiesParser getBuildPropertiesParser() {
        return this.buildPropertiesParser;
    }
}

