/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tycho.core.ee.shared.BuildFailureException;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.remote.IRepositoryIdManager;
import org.eclipse.tycho.p2.target.TargetDefinitionContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.util.resolution.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolutionDataImpl;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.p2.util.resolution.SlicerResolutionStrategy;
import org.eclipse.tycho.repository.util.DuplicateFilteringLoggingProgressMonitor;

public final class TargetDefinitionResolver {
    private static final String SOURCE_IU_ID = "org.eclipse.tycho.internal.target.source.bundles";
    private IMetadataRepositoryManager metadataManager;
    private IRepositoryIdManager repositoryIdManager;
    private final MavenLogger logger;
    private final List<TargetEnvironment> environments;
    private final ExecutionEnvironmentResolutionHints executionEnvironment;
    private final IProgressMonitor monitor;

    public TargetDefinitionResolver(List<TargetEnvironment> environments, ExecutionEnvironmentResolutionHints executionEnvironment, IProvisioningAgent agent, MavenLogger logger) {
        this.environments = environments;
        this.executionEnvironment = executionEnvironment;
        this.logger = logger;
        this.monitor = new DuplicateFilteringLoggingProgressMonitor(logger);
        this.metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        this.repositoryIdManager = (IRepositoryIdManager)agent.getService(IRepositoryIdManager.SERVICE_NAME);
    }

    public TargetDefinitionContent resolveContent(TargetDefinition definition) {
        try {
            return this.resolveContentWithExceptions(definition);
        }
        catch (TargetDefinitionSyntaxException e) {
            throw new BuildFailureException("Invalid syntax in target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (TargetDefinitionResolutionException e) {
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin() + ": " + e.getMessage(), (Throwable)e);
        }
        catch (ResolverException e) {
            this.logResolverException(e);
            throw new BuildFailureException("Failed to resolve target definition " + definition.getOrigin(), (Throwable)e);
        }
    }

    private void logResolverException(ResolverException e) {
        this.logger.error("Cannot resolve target definition:");
        new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
        this.logger.error("");
    }

    TargetDefinitionContent resolveContentWithExceptions(TargetDefinition definition) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException, ResolverException {
        ArrayList<URI> artifactRepositories = new ArrayList<URI>();
        ResolverRun resolverRun = new ResolverRun();
        for (TargetDefinition.Location locationDefinition : definition.getLocations()) {
            if (locationDefinition instanceof TargetDefinition.InstallableUnitLocation) {
                resolverRun.addLocation((TargetDefinition.InstallableUnitLocation)locationDefinition);
                for (TargetDefinition.Repository repository : ((TargetDefinition.InstallableUnitLocation)locationDefinition).getRepositories()) {
                    artifactRepositories.add(repository.getLocation());
                }
                continue;
            }
            this.logger.warn("Target location type '" + locationDefinition.getTypeDescription() + "' is not supported");
        }
        if (definition.hasIncludedBundles()) {
            this.logger.warn("De-selecting bundles in a target definition file is not supported. See http://wiki.eclipse.org/Tycho_Messages_Explained#Target_File_Include_Bundles for alternatives.");
        }
        return new TargetDefinitionContent(resolverRun.resolve(), artifactRepositories);
    }

    static CompoundQueryable<IInstallableUnit> compoundQueriable(List<? extends IQueryable<IInstallableUnit>> queryable) {
        return new CompoundQueryable(queryable.toArray(new IQueryable[queryable.size()]));
    }

    private class LoadedIULocation {
        private TargetDefinition.InstallableUnitLocation locationDefinition;
        private List<IMetadataRepository> loadedRepositories;

        public LoadedIULocation(TargetDefinition.InstallableUnitLocation locationDefinition) throws TargetDefinitionResolutionException {
            this.locationDefinition = locationDefinition;
            this.loadedRepositories = new ArrayList<IMetadataRepository>();
            for (TargetDefinition.Repository repository : locationDefinition.getRepositories()) {
                TargetDefinitionResolver.this.repositoryIdManager.addMapping(repository.getId(), repository.getLocation());
                this.loadedRepositories.add(this.loadRepository(repository));
            }
        }

        private IMetadataRepository loadRepository(TargetDefinition.Repository repository) throws TargetDefinitionResolutionException {
            try {
                return TargetDefinitionResolver.this.metadataManager.loadRepository(repository.getLocation(), TargetDefinitionResolver.this.monitor);
            }
            catch (ProvisionException e) {
                throw new TargetDefinitionResolutionException("Failed to load p2 metadata repository from location " + repository.getLocation(), (Throwable)e);
            }
        }

        public Collection<? extends IQueryable<IInstallableUnit>> getAvailableUnits() {
            return this.loadedRepositories;
        }

        public Collection<? extends IInstallableUnit> getRootIUs() throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
            ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
            for (TargetDefinition.Unit unitReference : this.locationDefinition.getUnits()) {
                result.add(this.findUnitInThisLocation(unitReference));
            }
            return result;
        }

        private IInstallableUnit findUnitInThisLocation(TargetDefinition.Unit unitReference) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
            IQueryResult<IInstallableUnit> queryResult = this.findUnit(unitReference, (IQueryable<IInstallableUnit>)TargetDefinitionResolver.compoundQueriable(this.loadedRepositories));
            if (queryResult.isEmpty()) {
                throw new TargetDefinitionResolutionException(NLS.bind((String)"Could not find \"{0}/{1}\" in the repositories of the current location", (Object)unitReference.getId(), (Object)unitReference.getVersion()));
            }
            IInstallableUnit unitInstance = (IInstallableUnit)queryResult.iterator().next();
            return unitInstance;
        }

        private IQueryResult<IInstallableUnit> findUnit(TargetDefinition.Unit unitReference, IQueryable<IInstallableUnit> units) throws TargetDefinitionSyntaxException {
            Version version = this.parseVersion(unitReference);
            IQuery matchingIUQuery = QueryUtil.createIUQuery((String)unitReference.getId(), (Version)version);
            IQuery latestMatchingIUQuery = QueryUtil.createLatestQuery((IQuery)matchingIUQuery);
            IQueryResult queryResult = units.query(latestMatchingIUQuery, (IProgressMonitor)new NullProgressMonitor());
            return queryResult;
        }

        private Version parseVersion(TargetDefinition.Unit unitReference) throws TargetDefinitionSyntaxException {
            try {
                return Version.parseVersion((String)unitReference.getVersion());
            }
            catch (IllegalArgumentException e) {
                throw new TargetDefinitionSyntaxException(NLS.bind((String)"Cannot parse version \"{0}\" of unit \"{1}\"", (Object)unitReference.getVersion(), (Object)unitReference.getId()), (Throwable)e);
            }
        }
    }

    private class ResolverRun {
        private List<IQueryable<IInstallableUnit>> availableUnitSources = new ArrayList<IQueryable<IInstallableUnit>>();
        private Set<IInstallableUnit> rootIUs = new LinkedHashSet<IInstallableUnit>();
        private TargetDefinition.IncludeMode includeMode = null;
        private Boolean includeAllEnvironments = null;
        private Boolean includeSource = null;

        private ResolverRun() {
        }

        public void addLocation(TargetDefinition.InstallableUnitLocation iuLocationDefinition) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
            this.setIncludeMode(iuLocationDefinition.getIncludeMode());
            this.setIncludeAllEnvironments(iuLocationDefinition.includeAllEnvironments());
            this.setIncludeSource(iuLocationDefinition.includeSource());
            LoadedIULocation loadedLocation = new LoadedIULocation(iuLocationDefinition);
            this.rootIUs.addAll(loadedLocation.getRootIUs());
            this.availableUnitSources.addAll(loadedLocation.getAvailableUnits());
        }

        private void setIncludeMode(TargetDefinition.IncludeMode newValue) throws TargetDefinitionResolutionException {
            if (this.includeMode != newValue) {
                if (this.includeMode != null) {
                    throw new TargetDefinitionResolutionException("Include mode must be the same for all locations");
                }
                this.includeMode = newValue;
            }
        }

        private void setIncludeAllEnvironments(Boolean newValue) throws TargetDefinitionResolutionException {
            if (!newValue.equals(this.includeAllEnvironments)) {
                if (this.includeAllEnvironments != null) {
                    throw new TargetDefinitionResolutionException("The attribute 'includeAllPlatforms' must be the same for all locations");
                }
                this.includeAllEnvironments = newValue;
            }
        }

        private void setIncludeSource(Boolean newValue) {
            if (!newValue.equals(this.includeSource)) {
                if (this.includeSource != null) {
                    throw new TargetDefinitionResolutionException("The attribute 'includeSource' must be the same for all locations");
                }
                this.includeSource = newValue;
            }
        }

        public Collection<IInstallableUnit> resolve() throws TargetDefinitionResolutionException, ResolverException {
            if (!this.addedLocationsHaveContent()) {
                return Collections.emptySet();
            }
            ResolutionDataImpl data = new ResolutionDataImpl(TargetDefinitionResolver.this.executionEnvironment);
            data.setRootIUs(this.rootIUs);
            data.setAvailableIUsAndFilter((IQueryable<IInstallableUnit>)TargetDefinitionResolver.compoundQueriable(this.availableUnitSources));
            AbstractResolutionStrategy strategy = this.getResolutionStrategy();
            strategy.setData(data);
            Collection<IInstallableUnit> units = strategy.multiPlatformResolve(TargetDefinitionResolver.this.environments, TargetDefinitionResolver.this.monitor);
            if (this.includeSource.booleanValue() && !units.isEmpty()) {
                this.addSourceBundleUnits(data, strategy, units);
            }
            return units;
        }

        private void addSourceBundleUnits(ResolutionDataImpl data, AbstractResolutionStrategy strategy, Collection<IInstallableUnit> units) throws ResolverException {
            IRequirement bundleRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false, (boolean)false);
            ArrayList<IRequirement> sourceBundleRequirements = new ArrayList<IRequirement>();
            for (IInstallableUnit unit : units) {
                if (!unit.satisfies(bundleRequirement)) continue;
                VersionRange perfectVersionMatch = new VersionRange(unit.getVersion(), true, unit.getVersion(), true);
                IRequirement optionalGreedySourceBundleRequirement = MetadataFactory.createRequirement((String)"osgi.bundle", (String)(String.valueOf(unit.getId()) + ".source"), (VersionRange)perfectVersionMatch, null, (boolean)true, (boolean)false, (boolean)true);
                sourceBundleRequirements.add(optionalGreedySourceBundleRequirement);
            }
            MetadataFactory.InstallableUnitDescription sourceDescription = new MetadataFactory.InstallableUnitDescription();
            sourceDescription.setId(TargetDefinitionResolver.SOURCE_IU_ID);
            Version sourceIUVersion = Version.createOSGi((int)1, (int)0, (int)0);
            sourceDescription.setVersion(sourceIUVersion);
            IProvidedCapability capability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)TargetDefinitionResolver.SOURCE_IU_ID, (Version)sourceIUVersion);
            sourceDescription.setCapabilities(new IProvidedCapability[]{capability});
            sourceDescription.addRequirements(sourceBundleRequirements);
            IInstallableUnit sourceIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)sourceDescription);
            data.setRootIUs(Collections.singleton(sourceIU));
            TargetEnvironment nonFilteringEnvironment = new TargetEnvironment();
            Collection<IInstallableUnit> sourceUnits = strategy.resolve(nonFilteringEnvironment, TargetDefinitionResolver.this.monitor);
            sourceUnits.remove(sourceIU);
            units.addAll(sourceUnits);
        }

        private boolean addedLocationsHaveContent() {
            return !this.availableUnitSources.isEmpty();
        }

        private AbstractResolutionStrategy getResolutionStrategy() throws TargetDefinitionResolutionException {
            switch (this.includeMode) {
                case PLANNER: {
                    return this.getPlannerResolutionStrategy();
                }
                case SLICER: {
                    return this.getSlicerResolutionStrategy();
                }
            }
            throw new IllegalStateException();
        }

        private AbstractResolutionStrategy getSlicerResolutionStrategy() {
            boolean ignoreFilters = this.includeAllEnvironments;
            return new SlicerResolutionStrategy(TargetDefinitionResolver.this.logger, ignoreFilters);
        }

        private AbstractResolutionStrategy getPlannerResolutionStrategy() throws TargetDefinitionResolutionException {
            if (this.includeAllEnvironments.booleanValue()) {
                throw new TargetDefinitionResolutionException("includeAllPlatforms='true' and includeMode='planner' are incompatible.");
            }
            return new ProjectorResolutionStrategy(TargetDefinitionResolver.this.logger);
        }
    }
}

