/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.classpath.ClasspathParser;
import org.eclipse.tycho.model.classpath.ProjectClasspathEntry;
import org.eclipse.tycho.model.classpath.SourceFolderClasspathEntry;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.eclipse.tycho.pomless.MavenConfiguation;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="eclipse-plugin")
public class TychoBundleMapping
extends AbstractTychoMapping {
    private static final String NAME_PREFIX = "[bundle] ";
    private static final String NAME_PREFIX_TEST = "[test-bundle] ";
    public static final String META_INF_DIRECTORY = "META-INF";
    public static final String MANIFEST_MF = "MANIFEST.MF";
    public static final String PACKAGING = "eclipse-plugin";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String PACKAGING_TEST = "eclipse-test-plugin";
    private static final String PDE_BND = "pde.bnd";
    private static final AtomicLong ID = new AtomicLong();

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    public float getPriority() {
        return 40.0f;
    }

    @Override
    protected boolean isValidLocation(Path polyglotFile) {
        String fileName = TychoBundleMapping.getFileName(polyglotFile);
        if (fileName.equals(META_INF_DIRECTORY) && Files.isRegularFile(polyglotFile.resolve(MANIFEST_MF), new LinkOption[0])) {
            return true;
        }
        return PDE_BND.equals(fileName) && Files.isRegularFile(polyglotFile, new LinkOption[0]);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File metaInfDirectory = new File(dir, META_INF_DIRECTORY);
        if (new File(metaInfDirectory, MANIFEST_MF).isFile()) {
            return metaInfDirectory;
        }
        File file = new File(dir, PDE_BND);
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        Path bndFile;
        String description;
        String prefix;
        Path bundleRoot = artifactFile.getParent();
        Path manifestFile = this.getManifestFile(artifactFile);
        Attributes manifestHeaders = this.readManifestHeaders(manifestFile);
        String bundleSymbolicName = this.getBundleSymbolicName(manifestHeaders, manifestFile);
        model.setArtifactId(bundleSymbolicName);
        String bundleVersion = this.getRequiredHeaderValue("Bundle-Version", manifestHeaders, manifestFile);
        model.setVersion(this.getPomVersion(bundleVersion, model, artifactFile));
        if (this.isTestBundle(bundleSymbolicName, bundleRoot)) {
            model.setPackaging(PACKAGING_TEST);
            prefix = NAME_PREFIX_TEST;
        } else {
            prefix = NAME_PREFIX;
        }
        Path l10nFile = TychoBundleMapping.getBundleLocalizationPropertiesFile(manifestHeaders, manifestFile);
        Supplier<Properties> properties = TychoBundleMapping.getPropertiesSupplier(l10nFile);
        String bundleName = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Name", properties);
        model.setName(prefix + (bundleName != null ? bundleName : bundleSymbolicName));
        String vendorName = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Vendor", properties);
        if (vendorName != null) {
            Organization organization = new Organization();
            organization.setName(vendorName);
            model.setOrganization(organization);
        }
        if ((description = TychoBundleMapping.getManifestAttributeValue(manifestHeaders, "Bundle-Description", properties)) != null) {
            model.setDescription(description);
        }
        if (Files.isRegularFile(bndFile = bundleRoot.resolve("bnd.bnd"), new LinkOption[0])) {
            TychoBundleMapping.createBndPlugin(model);
        }
        ArrayList<SourceFolderClasspathEntry> sourceFolders = new ArrayList<SourceFolderClasspathEntry>(1);
        ArrayList<SourceFolderClasspathEntry> testSourceFolders = new ArrayList<SourceFolderClasspathEntry>(1);
        for (ProjectClasspathEntry entry : ClasspathParser.parse((File)bundleRoot.toFile())) {
            if (!(entry instanceof SourceFolderClasspathEntry)) continue;
            SourceFolderClasspathEntry source = (SourceFolderClasspathEntry)entry;
            if (source.isTest()) {
                testSourceFolders.add(source);
                continue;
            }
            sourceFolders.add(source);
        }
        this.configureSourceFolders(model, bundleRoot, sourceFolders, false);
        this.configureSourceFolders(model, bundleRoot, testSourceFolders, true);
    }

    private void configureSourceFolders(Model model, Path bundleRoot, List<SourceFolderClasspathEntry> sourceFolders, boolean test) {
        if (sourceFolders.size() > 0) {
            SourceFolderClasspathEntry mainSrc = sourceFolders.remove(0);
            Path mainSourcePath = mainSrc.getSourcePath().toPath();
            String sourcePath = bundleRoot.relativize(mainSourcePath).toString();
            if (test) {
                TychoBundleMapping.getBuild(model).setTestSourceDirectory(sourcePath);
            } else {
                TychoBundleMapping.getBuild(model).setSourceDirectory(sourcePath);
            }
            this.addAdditionalFolders(sourceFolders, model, bundleRoot, test ? "add-test-source" : "add-source");
        }
    }

    private void addAdditionalFolders(List<SourceFolderClasspathEntry> folders, Model model, Path bundleRoot, String goal) {
        Plugin buildHelperPlugin = null;
        for (SourceFolderClasspathEntry entry : folders) {
            if (buildHelperPlugin == null) {
                buildHelperPlugin = TychoBundleMapping.getPlugin(model, "org.codehaus.mojo", "build-helper-maven-plugin");
            }
            TychoBundleMapping.addPluginExecution(buildHelperPlugin, execution -> {
                execution.setId("eclipse-classpath-" + goal + "-" + ID.incrementAndGet());
                execution.setPhase("initialize");
                execution.getGoals().add(goal);
                MavenConfiguation configuration = TychoBundleMapping.getConfiguration(execution);
                MavenConfiguation sources = configuration.addChild("sources");
                MavenConfiguation source = sources.addChild("source");
                Path additionalSourcePath = entry.getSourcePath().toPath();
                String additionalPath = bundleRoot.relativize(additionalSourcePath).toString();
                source.setValue(additionalPath);
            });
        }
    }

    private Path getManifestFile(Path artifactFile) {
        Path manifestFile = artifactFile.resolve(MANIFEST_MF);
        if (Files.isRegularFile(manifestFile, new LinkOption[0])) {
            return manifestFile;
        }
        if (TychoBundleMapping.getFileName(artifactFile).equals(PDE_BND) && Files.isRegularFile(artifactFile, new LinkOption[0])) {
            return artifactFile;
        }
        return manifestFile;
    }

    @Override
    protected Properties getEnhancementProperties(Path file) throws IOException {
        if (TychoBundleMapping.getFileName(file).equals(META_INF_DIRECTORY) && Files.isDirectory(file, new LinkOption[0])) {
            return TychoBundleMapping.getBuildProperties(file.getParent());
        }
        if (TychoBundleMapping.getFileName(file).equals(PDE_BND)) {
            return TychoBundleMapping.loadProperties(file);
        }
        return super.getEnhancementProperties(file);
    }

    private static Plugin createBndPlugin(Model model) {
        Plugin plugin = TychoBundleMapping.getPlugin(model, "biz.aQute.bnd", "bnd-maven-plugin");
        TychoBundleMapping.addPluginExecution(plugin, execution -> {
            execution.setId("bnd-process");
            execution.setGoals(Arrays.asList("bnd-process"));
            MavenConfiguation config = TychoBundleMapping.getConfiguration(execution);
            config.addChild("packagingTypes").setValue(model.getPackaging());
            config.addChild("manifestPath").setValue("${project.build.directory}/BND.MF");
        });
        return plugin;
    }

    private Attributes readManifestHeaders(Path manifestFile) throws IOException {
        Manifest manifest;
        block10: {
            manifest = new Manifest();
            try (InputStream stream = Files.newInputStream(manifestFile, new OpenOption[0]);){
                if (TychoBundleMapping.getFileName(manifestFile).equals(PDE_BND)) {
                    Properties properties = new Properties();
                    properties.load(stream);
                    Attributes attr = manifest.getMainAttributes();
                    for (String key : properties.stringPropertyNames()) {
                        try {
                            new Attributes.Name(key);
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        attr.putValue(key, properties.getProperty(key));
                    }
                    break block10;
                }
                manifest.read(stream);
            }
        }
        return manifest.getMainAttributes();
    }

    private String getBundleSymbolicName(Attributes headers, Path manifestFile) throws ModelParseException {
        String symbolicName = this.getRequiredHeaderValue(BUNDLE_SYMBOLIC_NAME, headers, manifestFile);
        int semicolonIndex = symbolicName.indexOf(59);
        if (semicolonIndex > 0) {
            symbolicName = symbolicName.substring(0, semicolonIndex);
        }
        return symbolicName;
    }

    private String getRequiredHeaderValue(String headerKey, Attributes headers, Path manifestFile) throws ModelParseException {
        String value = headers.getValue(headerKey);
        if (value == null) {
            throw new ModelParseException("Required header " + headerKey + " missing in " + manifestFile, -1, -1);
        }
        return value;
    }

    private boolean isTestBundle(String bundleSymbolicName, Path bundleRoot) throws IOException {
        Properties buildProperties = TychoBundleMapping.getBuildProperties(bundleRoot);
        String packagingProperty = buildProperties.getProperty("pom.model.packaging");
        if (PACKAGING.equalsIgnoreCase(packagingProperty)) {
            return false;
        }
        if (PACKAGING_TEST.equalsIgnoreCase(packagingProperty)) {
            return true;
        }
        return bundleSymbolicName.endsWith(".tests") || bundleSymbolicName.endsWith(".test");
    }

    private static String getManifestAttributeValue(Attributes headers, String attributeName, Supplier<Properties> localizationProperties) {
        String rawValue = headers.getValue(attributeName);
        String localizedValue = TychoBundleMapping.localizedValue(rawValue, localizationProperties);
        return localizedValue != null && !localizedValue.isBlank() ? localizedValue : null;
    }

    private static Path getBundleLocalizationPropertiesFile(Attributes headers, Path manifestFile) {
        String location = headers.getValue("Bundle-Localization");
        if (location == null || location.isEmpty()) {
            location = "OSGI-INF/l10n/bundle";
        }
        if (TychoBundleMapping.getFileName(manifestFile).equals(PDE_BND)) {
            return manifestFile.getParent().resolve(location + ".properties");
        }
        return manifestFile.getParent().getParent().resolve(location + ".properties");
    }
}

