/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXMLTychoMapping
extends AbstractTychoMapping {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    @Override
    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        this.initModelFromXML(model, AbstractXMLTychoMapping.parseXML(artifactReader, artifactFile.toUri().toASCIIString()), artifactFile);
    }

    protected abstract void initModelFromXML(Model var1, Element var2, Path var3) throws IOException;

    protected static Element parseXML(Reader artifactReader, String documentURI) throws IOException {
        try {
            DocumentBuilder parser = FACTORY.newDocumentBuilder();
            Document doc = parser.parse(new InputSource(artifactReader));
            if (documentURI != null) {
                doc.setDocumentURI(documentURI);
            }
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("parser failed", e);
        }
        catch (SAXException e) {
            int lineNumber = -1;
            int columnNumber = -1;
            if (e instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)e;
                lineNumber = parseException.getLineNumber();
                columnNumber = parseException.getColumnNumber();
            }
            throw new ModelParseException(e.getMessage(), lineNumber, columnNumber, (Throwable)e);
        }
    }

    protected static String getRequiredXMLAttributeValue(Element element, String attributeName) throws ModelParseException {
        String value = AbstractXMLTychoMapping.getXMLAttributeValue(element, attributeName);
        if (value == null) {
            throw new ModelParseException(String.format("missing or empty '%s' attribute in element '%s' (uri=%s)", attributeName, element.getNodeName(), element.getOwnerDocument().getDocumentURI()), -1, -1);
        }
        return value;
    }

    protected static String getXMLAttributeValue(Element element, String attributeName) {
        String value;
        Attr idNode = element.getAttributeNode(attributeName);
        if (idNode != null && (value = idNode.getValue()) != null && !value.isEmpty()) {
            return value;
        }
        return null;
    }

    public float getPriority() {
        return 1.0f;
    }

    protected static Stream<File> filesWithExtension(Path directory, String extension) throws IOException {
        Predicate<String> nameFilter = n -> !n.startsWith(".polyglot.") && n.endsWith(extension);
        return Files.walk(directory, 1, new FileVisitOption[0]).filter(p -> nameFilter.test(AbstractXMLTychoMapping.getFileName(p))).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile);
    }
}

