/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.maven.model.Build;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.pomless.MavenConfiguation;
import org.eclipse.tycho.pomless.NoParentPomFound;
import org.eclipse.tycho.pomless.ParentModel;
import org.eclipse.tycho.pomless.PomReference;
import org.sonatype.maven.polyglot.PolyglotModelUtil;
import org.sonatype.maven.polyglot.mapping.Mapping;

public abstract class AbstractTychoMapping
implements Mapping,
ModelReader {
    protected static final String TYCHO_GROUP_ID = "org.eclipse.tycho";
    protected static final String TYCHO_POMLESS_PARENT_PROPERTY = "tycho.pomless.parent";
    protected static final String TYCHO_POMLESS_AGGREGATOR_NAMES_PROPERTY = "tycho.pomless.aggregator.names";
    private static final String PARENT_POM_DEFAULT_VALUE = System.getProperty("tycho.pomless.parent", "..");
    private static final String QUALIFIER_SUFFIX = ".qualifier";
    private Map<Path, ParentModel> parentModelCache = new HashMap<Path, ParentModel>();
    @Requirement
    protected PlexusContainer container;
    @Requirement
    protected Logger logger;
    private ModelWriter writer;
    private boolean extensionMode;
    private File multiModuleProjectDirectory;
    private String snapshotProperty;

    public File locatePom(File dir) {
        File file = new File(dir, "pom.xml");
        if (file.exists()) {
            return null;
        }
        return this.getPrimaryArtifact(dir);
    }

    public boolean accept(Map<String, ?> options) {
        Optional<Path> location = AbstractTychoMapping.getLocation(options);
        if (location.isEmpty() || AbstractTychoMapping.getFileName(location.get()).equals("pom.xml")) {
            return false;
        }
        return this.isValidLocation(location.get());
    }

    public ModelReader getReader() {
        return this;
    }

    public ModelWriter getWriter() {
        if (this.writer == null) {
            try {
                assert (this.container != null);
                this.writer = (ModelWriter)this.container.lookup(ModelWriter.class, this.getFlavour());
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(e);
            }
        }
        return this.writer;
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Path file = AbstractTychoMapping.getLocation(options).orElseThrow(() -> new IOException("Failed to obtain file location"));
        try (InputStreamReader stream = new InputStreamReader(input, this.getPrimaryArtifactCharset());){
            Model model = this.read(stream, file, options);
            return model;
        }
    }

    public Model read(File inputFile, Map<String, ?> options) throws IOException {
        Path input = inputFile.toPath();
        Path artifactFile = this.getRealArtifactFile(input);
        if (Files.isDirectory(artifactFile, new LinkOption[0])) {
            return this.read(new StringReader(""), input, options);
        }
        if (Files.isRegularFile(artifactFile, new LinkOption[0])) {
            try (BufferedReader stream = Files.newBufferedReader(artifactFile, this.getPrimaryArtifactCharset());){
                Model model = this.read(stream, input, options);
                return model;
            }
        }
        return this.read(new StringReader(""), input, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Path file = AbstractTychoMapping.getLocation(options).orElseThrow(() -> new IOException("Failed to obtain file location"));
        return this.read(input, file, options);
    }

    private Model read(Reader artifactReader, Path artifactFile, Map<String, ?> options) throws IOException {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setPackaging(this.getPackaging());
        this.initModel(model, artifactReader, artifactFile);
        if (model.getParent() == null) {
            model.setParent(this.findParent(artifactFile.getParent(), options).parentReference());
        }
        if (model.getVersion() == null && model.getParent() != null) {
            model.setVersion(model.getParent().getVersion());
        }
        if (model.getName() == null) {
            model.setName(model.getArtifactId());
        }
        AbstractTychoMapping.setLocation(model, this.getRealArtifactFile(artifactFile));
        return model;
    }

    protected Path getRealArtifactFile(Path polyglotArtifactFile) {
        return polyglotArtifactFile;
    }

    protected synchronized ParentModel findParent(Path projectRoot, Map<String, ?> projectOptions) throws IOException {
        PomReference parentPom;
        ParentModel cached = this.parentModelCache.get(projectRoot);
        if (cached != null) {
            return cached;
        }
        Properties buildProperties = AbstractTychoMapping.getBuildProperties(projectRoot);
        String parentRef = buildProperties.getProperty(TYCHO_POMLESS_PARENT_PROPERTY, PARENT_POM_DEFAULT_VALUE);
        Path fileOrFolder = projectRoot.resolve(parentRef).toRealPath(new LinkOption[0]);
        if (Files.isRegularFile(fileOrFolder, new LinkOption[0])) {
            parentPom = this.locatePomReference(fileOrFolder.getParent(), AbstractTychoMapping.getFileName(fileOrFolder));
        } else if (Files.isDirectory(fileOrFolder, new LinkOption[0])) {
            parentPom = this.locatePomReference(fileOrFolder, null);
        } else {
            throw new FileNotFoundException("parent pom file/folder " + fileOrFolder + " is not accessible");
        }
        if (parentPom == null) {
            throw new NoParentPomFound(fileOrFolder);
        }
        HashMap<String, FileModelSource> options = new HashMap<String, FileModelSource>(1);
        options.put("org.apache.maven.model.building.source", new FileModelSource(parentPom.getPomFile()));
        Model parentModel = parentPom.getReader().read(parentPom.getPomFile(), options);
        Parent parentReference = new Parent();
        String groupId = parentModel.getGroupId();
        Parent grandParent = parentModel.getParent();
        if (groupId == null && grandParent != null) {
            groupId = grandParent.getGroupId();
        }
        parentReference.setGroupId(groupId);
        parentReference.setArtifactId(parentModel.getArtifactId());
        String version = parentModel.getVersion();
        if (version == null && grandParent != null) {
            version = grandParent.getVersion();
        }
        parentReference.setVersion(version);
        parentReference.setRelativePath(projectRoot.toRealPath(new LinkOption[0]).relativize(parentPom.getPomFile().toPath()).toString());
        this.logger.debug("Derived parent for path " + projectRoot + " is groupId: " + parentReference.getGroupId() + ", artifactId: " + parentReference.getArtifactId() + ", relativePath: " + parentReference.getRelativePath());
        ParentModel model = new ParentModel(parentReference, parentModel);
        this.parentModelCache.put(projectRoot, model);
        return model;
    }

    protected PomReference locatePomReference(Path folderPath, String nameHint) {
        File folder = folderPath.toFile();
        PomReference reference = null;
        try {
            List lookupList = this.container.lookupList(ModelProcessor.class);
            for (ModelProcessor processor : lookupList) {
                File pom = processor.locatePom(folder);
                if (pom == null || reference != null && !pom.getName().equals(nameHint) || !pom.exists()) continue;
                reference = new PomReference(pom, (ModelReader)processor);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return reference;
    }

    public String getFlavour() {
        return this.getPackaging();
    }

    protected abstract boolean isValidLocation(Path var1);

    protected abstract File getPrimaryArtifact(File var1);

    protected abstract String getPackaging();

    protected Charset getPrimaryArtifactCharset() {
        return StandardCharsets.UTF_8;
    }

    protected abstract void initModel(Model var1, Reader var2, Path var3) throws IOException;

    protected static Properties getBuildProperties(Path dir) throws IOException {
        return AbstractTychoMapping.loadProperties(dir.resolve("build.properties"));
    }

    static Properties loadProperties(Path propertiesPath) throws IOException {
        Properties properties = new Properties();
        if (Files.isRegularFile(propertiesPath, new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(propertiesPath, new OpenOption[0]);){
                properties.load(stream);
            }
        }
        return properties;
    }

    static Supplier<Properties> getPropertiesSupplier(final Path propertiesFile) {
        return new Supplier<Properties>(){
            private Properties properties;

            @Override
            public Properties get() {
                if (this.properties == null) {
                    try {
                        this.properties = AbstractTychoMapping.loadProperties(propertiesFile);
                    }
                    catch (IOException e) {
                        return new Properties();
                    }
                }
                return this.properties;
            }
        };
    }

    static String localizedValue(String value, Supplier<Properties> properties) {
        if (value != null && value.startsWith("%")) {
            String key = value.substring(1);
            String translation = properties.get().getProperty(key);
            return translation != null && !translation.isEmpty() ? translation : key;
        }
        return value;
    }

    public Properties getEnhancementProperties(Map<String, ?> options) {
        Optional<Path> file = AbstractTychoMapping.getLocation(options);
        try {
            if (file.isPresent()) {
                return this.getEnhancementProperties(file.get());
            }
        }
        catch (IOException e) {
            this.logger.warn("Reading EnhancementProperties encountered a problem and was skipped for this reason", (Throwable)e);
        }
        return null;
    }

    protected Properties getEnhancementProperties(Path file) throws IOException {
        Path dir = Files.isDirectory(file, new LinkOption[0]) ? file : file.getParent();
        return AbstractTychoMapping.getBuildProperties(dir);
    }

    private static void setLocation(Model model, Path modelSource) {
        InputSource inputSource = new InputSource();
        inputSource.setLocation(modelSource.toString());
        String groupId = model.getGroupId();
        if (groupId == null) {
            Parent parent = model.getParent();
            groupId = parent == null ? "-" : parent.getGroupId();
        }
        inputSource.setModelId(groupId + ":" + model.getArtifactId() + ":" + model.getVersion());
        model.setLocation((Object)"", new InputLocation(0, 0, inputSource));
    }

    protected String getPomVersion(String pdeVersion, Model model, Path projectRoot) {
        String pomVersion = pdeVersion;
        if (pdeVersion.endsWith(QUALIFIER_SUFFIX)) {
            String unqualifiedVersion = pdeVersion.substring(0, pdeVersion.length() - QUALIFIER_SUFFIX.length());
            if (this.isExtensionMode() && this.modelHasProperty(this.snapshotProperty, model, projectRoot)) {
                return unqualifiedVersion + "${" + this.snapshotProperty + "}";
            }
            return unqualifiedVersion + "-SNAPSHOT";
        }
        return pomVersion;
    }

    private boolean modelHasProperty(String property, Model model, Path projectRoot) {
        if (property == null) {
            return false;
        }
        Properties properties = model.getProperties();
        String string = properties.getProperty(property);
        if (string != null) {
            return true;
        }
        try {
            ParentModel parent = this.findParent(projectRoot.getParent(), Map.of());
            Model parentModel = parent.parentModel();
            if (parentModel != null) {
                return this.modelHasProperty(property, parentModel, projectRoot.resolve(parent.parentReference().getRelativePath()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isExtensionMode() {
        return this.extensionMode;
    }

    public void setExtensionMode(boolean extensionMode) {
        this.extensionMode = extensionMode;
    }

    public void setMultiModuleProjectDirectory(File multiModuleProjectDirectory) {
        this.multiModuleProjectDirectory = multiModuleProjectDirectory;
    }

    public void setSnapshotProperty(String snapshotFormat) {
        this.snapshotProperty = snapshotFormat;
    }

    static Optional<Path> getLocation(Map<String, ?> options) {
        String location = PolyglotModelUtil.getLocation(options);
        if (location != null) {
            try {
                return Optional.of(Path.of(location, new String[0]));
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    protected static String getFileName(Path file) {
        return file.getFileName().toString();
    }

    protected static Plugin disablePluginExecution(Model model, String groupId, String artifactId, String executionId) {
        Plugin plugin = AbstractTychoMapping.getPlugin(model, groupId, artifactId);
        PluginExecution execution = new PluginExecution();
        execution.setId(executionId);
        execution.setPhase("none");
        plugin.addExecution(execution);
        return plugin;
    }

    protected static Plugin addPluginExecution(Plugin plugin, Consumer<PluginExecution> init) {
        PluginExecution execution = new PluginExecution();
        init.accept(execution);
        plugin.addExecution(execution);
        return plugin;
    }

    protected static Plugin getPlugin(Model model, String groupId, String artifactId) {
        Build build = AbstractTychoMapping.getBuild(model);
        for (Plugin existing : build.getPlugins()) {
            if (!existing.getGroupId().equals(groupId) || !existing.getArtifactId().equals(artifactId)) continue;
            return existing;
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId(groupId);
        plugin.setArtifactId(artifactId);
        build.addPlugin(plugin);
        return plugin;
    }

    protected static Build getBuild(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        return build;
    }

    protected static MavenConfiguation getConfiguration(PluginExecution execution) {
        Object config = execution.getConfiguration();
        MavenConfiguation mavenConfiguation = new MavenConfiguation(config, "configuration");
        if (config == null) {
            execution.setConfiguration(mavenConfiguation.getXpp3());
        }
        return mavenConfiguation;
    }
}

