/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.ModelParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractXMLTychoMapping;
import org.eclipse.tycho.pomless.MavenConfiguation;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.w3c.dom.Element;

@Component(role=Mapping.class, hint="eclipse-repository")
public class TychoRepositoryMapping
extends AbstractXMLTychoMapping {
    private static final String ARCHIVE_PRODUCTS_ID = "archive-products";
    private static final String MATERIALIZE_PRODUCTS_ID = "materialize-products";
    private static final List<String> PRODUCT_EXECUTIONS = List.of("archive-products", "materialize-products");
    private static final String PRODUCT_NAME_PREFIX = "[product] ";
    private static final String PRODUCT_NAME_ATTRIBUTE = "name";
    private static final String PRODUCT_VERSION_ATTRIBUTE = "version";
    private static final String PRODUCT_UID_ATTRIBUTE = "uid";
    private static final String CATEGORY_XML = "category.xml";
    private static final String PRODUCT_EXTENSION = ".product";
    public static final String PACKAGING = "eclipse-repository";
    private static final String UPDATE_SITE_SUFFIX = ".eclipse-repository";

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    @Override
    public float getPriority() {
        return 20.0f;
    }

    @Override
    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        block13: {
            if (TychoRepositoryMapping.getFileName(artifactFile).endsWith(PRODUCT_EXTENSION)) {
                Path projectRoot = artifactFile.getParent();
                try (Stream<File> files = TychoRepositoryMapping.filesWithExtension(projectRoot, PRODUCT_EXTENSION);){
                    List<File> products = files.toList();
                    if (products.size() <= 1) break block13;
                    model.setArtifactId(TychoRepositoryMapping.getFileName(projectRoot));
                    Plugin directorPlugin = TychoRepositoryMapping.createDirectorPlugin(model);
                    ArrayList<String> names = new ArrayList<String>();
                    for (File file : products) {
                        Element productXml;
                        try (FileReader reader = new FileReader(file, this.getPrimaryArtifactCharset());){
                            productXml = TychoRepositoryMapping.parseXML(reader, file.toURI().toASCIIString());
                        }
                        String baseName = FilenameUtils.getBaseName((String)file.getName());
                        String name = TychoRepositoryMapping.getXMLAttributeValue(productXml, PRODUCT_NAME_ATTRIBUTE);
                        names.add(null == name ? baseName : name);
                        TychoRepositoryMapping.addProduct(directorPlugin, productXml, baseName);
                    }
                    model.setName(PRODUCT_NAME_PREFIX + String.join((CharSequence)", ", names));
                    return;
                }
            }
        }
        super.initModel(model, artifactReader, artifactFile);
    }

    @Override
    protected void initModelFromXML(Model model, Element xml, Path artifactFile) throws IOException {
        if (TychoRepositoryMapping.getFileName(artifactFile).endsWith(PRODUCT_EXTENSION)) {
            String name;
            model.setArtifactId(TychoRepositoryMapping.getRequiredXMLAttributeValue(xml, PRODUCT_UID_ATTRIBUTE));
            String version = TychoRepositoryMapping.getXMLAttributeValue(xml, PRODUCT_VERSION_ATTRIBUTE);
            if (version != null) {
                model.setVersion(this.getPomVersion(version));
            }
            model.setName(PRODUCT_NAME_PREFIX + ((name = TychoRepositoryMapping.getXMLAttributeValue(xml, PRODUCT_NAME_ATTRIBUTE)) != null ? name : model.getArtifactId()));
            TychoRepositoryMapping.addProduct(TychoRepositoryMapping.createDirectorPlugin(model), xml, null);
        } else {
            TychoRepositoryMapping.initFromCategory(model, artifactFile);
        }
    }

    private static void initFromCategory(Model model, Path categoryXml) {
        Object name = TychoRepositoryMapping.getFileName(categoryXml.getParent());
        if (!((String)name).endsWith(UPDATE_SITE_SUFFIX)) {
            name = (String)name + UPDATE_SITE_SUFFIX;
        }
        model.setArtifactId((String)name);
        model.setName("[updatesite] " + (String)name);
    }

    @Override
    protected boolean isValidLocation(Path location) {
        String fileName = TychoRepositoryMapping.getFileName(location);
        return fileName.endsWith(PRODUCT_EXTENSION) || fileName.endsWith(CATEGORY_XML);
    }

    @Override
    protected File getPrimaryArtifact(File projectRoot) {
        Optional<Object> repoFile;
        try (Stream<File> files = TychoRepositoryMapping.filesWithExtension(projectRoot.toPath(), PRODUCT_EXTENSION);){
            repoFile = files.findFirst();
        }
        catch (IOException e) {
            repoFile = Optional.empty();
        }
        return repoFile.or(() -> Optional.of(new File(projectRoot, CATEGORY_XML)).filter(File::exists)).orElse(null);
    }

    private static void addProduct(Plugin directorPlugin, Element productXml, String attachId) throws ModelParseException {
        Map map = directorPlugin.getExecutionsAsMap();
        for (String executionId : PRODUCT_EXECUTIONS) {
            PluginExecution pluginExecution = map.computeIfAbsent(executionId, required -> {
                throw new IllegalArgumentException(required + " PluginExecution is missing");
            });
            MavenConfiguation config = TychoRepositoryMapping.getConfiguration(pluginExecution);
            MavenConfiguation products = config.getChild("products");
            MavenConfiguation product = products.addChild("product");
            product.addChild("id").setValue(TychoRepositoryMapping.getRequiredXMLAttributeValue(productXml, PRODUCT_UID_ATTRIBUTE));
            if (attachId == null) continue;
            product.addChild("attachId").setValue(attachId);
        }
    }

    private static Plugin createDirectorPlugin(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        Plugin plugin = new Plugin();
        plugin.setArtifactId("tycho-p2-director-plugin");
        plugin.setGroupId("org.eclipse.tycho");
        build.addPlugin(plugin);
        PluginExecution materialize = new PluginExecution();
        materialize.setId(MATERIALIZE_PRODUCTS_ID);
        materialize.setGoals(Arrays.asList(MATERIALIZE_PRODUCTS_ID));
        plugin.addExecution(materialize);
        PluginExecution archive = new PluginExecution();
        archive.setId(ARCHIVE_PRODUCTS_ID);
        archive.setGoals(Arrays.asList(ARCHIVE_PRODUCTS_ID));
        plugin.addExecution(archive);
        return plugin;
    }
}

