/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.extras;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.exceptions.VersionBumpRequiredException;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;
import org.osgi.framework.Version;

@Mojo(defaultPhase=LifecyclePhase.VERIFY, requiresProject=false, name="compare-version-with-baselines", threadSafe=true)
public class CompareWithBaselineMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="mojoExecution", readonly=true)
    protected MojoExecution execution;
    @Parameter(property="baselines", name="baselines")
    private List<String> baselines;
    @Parameter
    private List<String> ignoredPatterns;
    @Parameter(property="skip", alias="tycho.p2.baseline.skip")
    private boolean skip;
    @Parameter(property="onIllegalVersion", defaultValue="fail", alias="tycho.p2.baseline.onIllegalVersion")
    private ReportBehavior onIllegalVersion;
    @Component
    P2ResolverFactory resolverFactory;
    @Component
    private Logger plexusLogger;
    @Component
    private TychoProjectManager projectManager;
    @Component
    private TargetPlatformFactory platformFactory;
    @Parameter(defaultValue="bytes")
    private String comparator;
    @Component(role=ArtifactComparator.class)
    protected Map<String, ArtifactComparator> artifactComparators;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution was skipped");
            return;
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        Set dependencyMetadata = reactorProject.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED);
        if (dependencyMetadata == null || dependencyMetadata.isEmpty()) {
            this.getLog().debug((CharSequence)"Skipping baseline version comparison, no p2 artifacts created in build");
            return;
        }
        if (!this.artifactComparators.containsKey(this.comparator)) {
            throw new MojoExecutionException("Unknown comparator `" + this.comparator + "`. Known comparators are: " + this.artifactComparators.keySet());
        }
        TargetEnvironment runningEnvironment = TargetEnvironment.getRunningEnvironment();
        P2Resolver resolver = this.resolverFactory.createResolver(Collections.singletonList(runningEnvironment));
        TargetPlatformConfigurationStub baselineTPStub = new TargetPlatformConfigurationStub();
        baselineTPStub.setIgnoreLocalArtifacts(true);
        baselineTPStub.setEnvironments(Collections.singletonList(runningEnvironment));
        for (String baselineRepo : this.baselines) {
            baselineTPStub.addP2Repository(this.toRepoURI(baselineRepo));
        }
        ExecutionEnvironmentConfiguration eeConfiguration = this.projectManager.getExecutionEnvironmentConfiguration(this.project);
        TargetPlatform baselineTP = this.platformFactory.createTargetPlatform(baselineTPStub, eeConfiguration, null);
        for (IInstallableUnit item : dependencyMetadata) {
            try {
                String id = item.getId();
                Version version = new Version(item.getVersion().toString());
                P2ResolutionResult res = resolver.resolveInstallableUnit(baselineTP, id, "0.0.0");
                for (P2ResolutionResult.Entry foundInBaseline : res.getArtifacts()) {
                    String message;
                    Version baselineVersion = new Version(foundInBaseline.getVersion());
                    String versionDelta = version.getMajor() - baselineVersion.getMajor() + "." + (version.getMinor() - baselineVersion.getMinor()) + "." + (version.getMicro() - baselineVersion.getMicro());
                    this.getLog().debug((CharSequence)("Found " + foundInBaseline.getId() + "/" + foundInBaseline.getVersion() + " with delta: " + versionDelta));
                    if (version.compareTo(baselineVersion) < 0) {
                        message = "Version has moved backwards for (" + id + "/" + version + "). Baseline has " + baselineVersion + ") with delta: " + versionDelta;
                        if (this.onIllegalVersion == ReportBehavior.warn) {
                            this.getLog().warn((CharSequence)message);
                            return;
                        }
                        throw new MojoFailureException(message);
                    }
                    if (version.equals((Object)baselineVersion)) {
                        File baselineFile = foundInBaseline.getLocation(true);
                        File reactorFile = null;
                        reactorFile = id.endsWith("source") ? reactorProject.getArtifact("sources") : (id.endsWith("source.feature.jar") ? reactorProject.getArtifact("sources-feature") : (id.endsWith("_root") ? reactorProject.getArtifact("root") : reactorProject.getArtifact()));
                        ArtifactComparator.ComparisonData data = new ArtifactComparator.ComparisonData(this.ignoredPatterns, false);
                        ArtifactDelta artifactDelta = this.artifactComparators.get(this.comparator).getDelta(baselineFile, reactorFile, data);
                        Object message2 = "Baseline and reactor have the same fully qualified version, but different content";
                        if (artifactDelta == null) continue;
                        if (this.onIllegalVersion == ReportBehavior.warn) {
                            this.getLog().warn((CharSequence)message2);
                            this.getLog().warn((CharSequence)artifactDelta.getDetailedMessage());
                            return;
                        }
                        message2 = (String)message2 + "\n";
                        message2 = (String)message2 + artifactDelta.getDetailedMessage();
                        this.getLog().error((CharSequence)message2);
                        throw new MojoFailureException((String)message2);
                    }
                    if (version.getMajor() != baselineVersion.getMajor() || version.getMinor() != baselineVersion.getMinor() || version.getMicro() != baselineVersion.getMicro()) continue;
                    message = "Only qualifier changed for (" + id + "/" + version + "). Expected to have bigger x.y.z than what is available in baseline (" + baselineVersion + ")";
                    if (this.onIllegalVersion == ReportBehavior.warn) {
                        this.getLog().warn((CharSequence)message);
                        return;
                    }
                    throw new VersionBumpRequiredException(message, item, version, baselineVersion);
                }
            }
            catch (Exception ex) {
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private URI toRepoURI(String s) throws MojoExecutionException {
        if (new File(s).exists()) {
            return new File(s).toURI();
        }
        if (new File(this.project.getBasedir(), s).exists()) {
            return new File(this.project.getBasedir(), s).toURI();
        }
        try {
            return new URI(s);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Wrong baseline: '" + s + "'", ex);
        }
    }

    public static enum ReportBehavior {
        fail,
        warn;

    }
}

