/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.extras;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;

@Mojo(name="publish-features-and-bundles")
public class PublishFeaturesAndBundlesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/repository")
    private String metadataRepositoryLocation;
    @Parameter(defaultValue="${project.build.directory}/repository")
    private String artifactRepositoryLocation;
    @Parameter(defaultValue="${project.build.directory}/source")
    private String sourceLocation;
    @Parameter(defaultValue="true")
    private boolean compress;
    @Parameter(defaultValue="false")
    private boolean append;
    @Parameter(defaultValue="true")
    private boolean publishArtifacts;
    @Parameter(defaultValue="")
    private String additionalArgs;
    @Parameter(property="project")
    private MavenProject project;
    @Component
    private IProvisioningAgent agent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.publishContent();
    }

    private void publishContent() throws MojoExecutionException, MojoFailureException {
        try {
            File sourceRepositoryDir = new File(this.sourceLocation).getCanonicalFile();
            File artifactRepositoryDir = new File(this.artifactRepositoryLocation).getCanonicalFile();
            File metadataRepositoryDir = new File(this.metadataRepositoryLocation).getCanonicalFile();
            ArrayList<String> contentArgs = new ArrayList<String>();
            contentArgs.add("-source");
            contentArgs.add(sourceRepositoryDir.toString());
            this.agent.getService(IArtifactRepositoryManager.class);
            FeaturesAndBundlesPublisherApplication application = new FeaturesAndBundlesPublisherApplication();
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("-artifactRepository");
            arguments.add(artifactRepositoryDir.toURL().toString());
            arguments.add("-metadataRepository");
            arguments.add(metadataRepositoryDir.toURL().toString());
            arguments.addAll(Arrays.asList(this.getPublishArtifactFlag()));
            arguments.addAll(Arrays.asList(this.getAppendFlag()));
            arguments.addAll(Arrays.asList(this.getCompressFlag()));
            arguments.addAll(Arrays.asList(this.getAdditionalArgs()));
            arguments.addAll(Arrays.asList(contentArgs.toArray(new String[contentArgs.size()])));
            Object result = application.run((String[])arguments.toArray(String[]::new));
            if (result != IApplication.EXIT_OK) {
                throw new MojoFailureException("P2 publisher return code was " + result);
            }
        }
        catch (Exception ioe) {
            throw new MojoFailureException("Unable to execute the publisher", (Throwable)ioe);
        }
    }

    private String[] getCompressFlag() {
        String[] stringArray;
        if (this.compress) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-compress";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getAppendFlag() {
        String[] stringArray;
        if (this.append) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-append";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getPublishArtifactFlag() {
        String[] stringArray;
        if (this.publishArtifacts) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "-publishArtifacts";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private String[] getAdditionalArgs() throws MojoExecutionException {
        if (this.additionalArgs == null || "".equals(this.additionalArgs)) {
            return new String[0];
        }
        try {
            return CommandLineUtils.translateCommandline((String)this.additionalArgs);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to translate additional arguments into command line array", e);
        }
    }
}

