/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.buildtimestamp.jgit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.ignore.FastIgnoreRule;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    private final byte[] basedir;
    private final List<FastIgnoreRule> rules;

    public PathFilter(String basedir, String filters) {
        this.basedir = Constants.encode((String)basedir);
        if (filters != null) {
            StringTokenizer st = new StringTokenizer(filters, "\n\r\f", false);
            ArrayList<FastIgnoreRule> rules = new ArrayList<FastIgnoreRule>();
            while (st.hasMoreTokens()) {
                String trimmed = st.nextToken().trim();
                if (trimmed.length() <= 0) continue;
                rules.add(new FastIgnoreRule(trimmed));
            }
            this.rules = Collections.unmodifiableList(rules);
        } else {
            this.rules = null;
        }
    }

    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (tw.isPathPrefix(this.basedir, this.basedir.length) != 0) {
            return false;
        }
        if (!tw.isSubtree() && this.rules != null) {
            String path = tw.getPathString();
            for (FastIgnoreRule rule : this.rules) {
                if (!rule.isMatch(path, tw.isSubtree())) continue;
                return !rule.getResult();
            }
        }
        return true;
    }

    public boolean shouldBeRecursive() {
        return true;
    }

    public TreeFilter clone() {
        return this;
    }
}

