/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.json.DataSetDeserializer;
import org.eclipse.tahu.message.model.DataSetDataType;
import org.eclipse.tahu.message.model.Row;
import org.eclipse.tahu.message.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=DataSetDeserializer.class)
public class DataSet {
    private static final Logger logger = LoggerFactory.getLogger((String)DataSet.class.getName());
    @JsonProperty(value="numberOfColumns")
    private long numOfColumns;
    @JsonProperty(value="columnNames")
    private List<String> columnNames;
    @JsonProperty(value="types")
    private List<DataSetDataType> types;
    private List<Row> rows;

    public DataSet() {
    }

    public DataSet(long numOfColumns, List<String> columnNames, List<DataSetDataType> types, List<Row> rows) {
        this.numOfColumns = numOfColumns;
        this.columnNames = columnNames;
        this.types = types;
        this.rows = rows;
    }

    public DataSet(DataSet dataSet) throws TahuException {
        this.numOfColumns = dataSet.getNumOfColumns();
        if (this.numOfColumns > 0L) {
            if (dataSet.getColumnNames() == null || dataSet.getTypes() == null || dataSet.getColumnNames().size() != dataSet.getTypes().size()) {
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid DataSet to copy " + dataSet);
            }
            this.columnNames = new ArrayList<String>();
            for (String columnName : dataSet.getColumnNames()) {
                this.columnNames.add(columnName);
            }
            this.types = new ArrayList<DataSetDataType>();
            for (DataSetDataType type : dataSet.getTypes()) {
                this.types.add(type);
            }
            this.rows = new ArrayList<Row>();
            if (dataSet.getRows() != null) {
                for (Row row : dataSet.getRows()) {
                    this.rows.add(new Row(row));
                }
            }
        }
    }

    public long getNumOfColumns() {
        return this.numOfColumns;
    }

    public void setNumOfColumns(long numOfColumns) {
        this.numOfColumns = numOfColumns;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public void addColumnName(String columnName) {
        this.columnNames.add(columnName);
    }

    public List<Row> getRows() {
        return this.rows;
    }

    @JsonGetter(value="rows")
    public List<List<Object>> getRowsAsLists() {
        if (this.getRows() == null) {
            return Lists.newArrayList();
        }
        ArrayList<List<Object>> list = new ArrayList<List<Object>>(this.getRows().size());
        for (Row row : this.getRows()) {
            list.add(Row.toValues(row));
        }
        return list;
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addRow(int index, Row row) {
        this.rows.add(index, row);
    }

    public Row removeRow(int index) {
        return this.rows.remove(index);
    }

    public boolean removeRow(Row row) {
        return this.rows.remove(row);
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public List<DataSetDataType> getTypes() {
        return this.types;
    }

    public void setTypes(List<DataSetDataType> types) {
        this.types = types;
    }

    public void addType(DataSetDataType type) {
        this.types.add(type);
    }

    public void addType(int index, DataSetDataType type) {
        this.types.add(index, type);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataSet [numOfColumns=");
        builder.append(this.numOfColumns);
        builder.append(", columnNames=");
        builder.append(this.columnNames);
        builder.append(", types=");
        if (this.types != null) {
            builder.append("[");
            for (int i = 0; i < this.types.size(); ++i) {
                builder.append(this.types.get(i).getType());
                if (i + 1 == this.types.size()) continue;
                builder.append(", ");
            }
            builder.append("]");
        } else {
            builder.append("null");
        }
        builder.append(", rows=");
        builder.append(this.rows);
        builder.append("]");
        return builder.toString();
    }

    public static class DataSetBuilder {
        private long numOfColumns;
        private List<String> columnNames;
        private List<DataSetDataType> types;
        private List<Row> rows;

        public DataSetBuilder(long numOfColumns) {
            this.numOfColumns = numOfColumns;
            this.columnNames = new ArrayList<String>();
            this.types = new ArrayList<DataSetDataType>();
            this.rows = new ArrayList<Row>();
        }

        public DataSetBuilder(DataSet dataSet) {
            this.numOfColumns = dataSet.getNumOfColumns();
            this.columnNames = dataSet.getColumnNames() == null ? Lists.newArrayList() : new ArrayList<String>(dataSet.getColumnNames());
            this.types = dataSet.getTypes() == null ? Lists.newArrayList() : new ArrayList<DataSetDataType>(dataSet.getTypes());
            if (dataSet.getRows() == null) {
                this.rows = Lists.newArrayList();
            } else {
                this.rows = new ArrayList<Row>(dataSet.getRows().size());
                for (Row row : dataSet.getRows()) {
                    this.rows.add(new Row.RowBuilder(row).createRow());
                }
            }
        }

        public DataSetBuilder addColumnNames(Collection<String> columnNames) {
            this.columnNames.addAll(columnNames);
            return this;
        }

        public DataSetBuilder addColumnName(String columnName) {
            this.columnNames.add(columnName);
            return this;
        }

        public DataSetBuilder addType(DataSetDataType type) {
            this.types.add(type);
            return this;
        }

        public DataSetBuilder addTypes(Collection<DataSetDataType> types) {
            this.types.addAll(types);
            return this;
        }

        public DataSetBuilder addRow(Row row) {
            this.rows.add(row);
            return this;
        }

        public DataSetBuilder addRows(Collection<Row> rows) {
            this.rows.addAll(rows);
            return this;
        }

        public DataSet createDataSet() throws SparkplugException {
            logger.trace("Number of columns: " + this.numOfColumns);
            for (String columnName : this.columnNames) {
                logger.trace("\tcolumnName: " + columnName);
            }
            for (DataSetDataType type : this.types) {
                logger.trace("\ttypes: " + type);
            }
            for (Row row : this.rows) {
                logger.trace("\t\trow: " + row);
            }
            this.validate();
            return new DataSet(this.numOfColumns, this.columnNames, this.types, this.rows);
        }

        public void validate() throws SparkplugException {
            if ((long)this.columnNames.size() != this.numOfColumns) {
                throw new SparkplugException("Invalid number of columns in data set column names: " + this.columnNames.size() + " vs expected " + this.numOfColumns);
            }
            if ((long)this.types.size() != this.numOfColumns) {
                throw new SparkplugException("Invalid number of columns in data set types: " + this.types.size() + " vs expected: " + this.numOfColumns);
            }
            for (int i = 0; i < this.types.size(); ++i) {
                for (Row row : this.rows) {
                    List<Value<?>> values = row.getValues();
                    if ((long)values.size() != this.numOfColumns) {
                        throw new SparkplugException("Invalid number of columns in data set row: " + values.size() + " vs expected: " + this.numOfColumns);
                    }
                    this.types.get(i).checkType(row.getValues().get(i).getValue());
                }
            }
        }
    }
}

