/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.host.CommandPublisher;
import org.eclipse.tahu.host.TahuHostCallback;
import org.eclipse.tahu.host.api.MultiHostApplicationEventHandler;
import org.eclipse.tahu.host.seq.SequenceReorderManager;
import org.eclipse.tahu.message.PayloadDecoder;
import org.eclipse.tahu.message.SparkplugBPayloadEncoder;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.Topic;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.eclipse.tahu.mqtt.RandomStartupDelay;
import org.eclipse.tahu.mqtt.TahuClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostApplication
implements CommandPublisher {
    private static Logger logger = LoggerFactory.getLogger((String)HostApplication.class.getName());
    private static int MAX_INFLIGHT_MESSAGES = 500;
    private final String hostId;
    private final RandomStartupDelay randomStartupDelay;
    private final String stateTopic;
    private final List<String> sparkplugSubscriptons;
    private final TahuHostCallback tahuHostCallback;
    private final List<MqttServerDefinition> mqttServerDefinitions;
    private final Map<MqttServerName, TahuClient> tahuClients = new HashMap<MqttServerName, TahuClient>();

    public HostApplication(MultiHostApplicationEventHandler eventHandler, String hostId, List<String> sparkplugSubscriptons, List<MqttServerDefinition> mqttServerDefinitions, RandomStartupDelay randomStartupDelay, PayloadDecoder<SparkplugBPayload> payloadDecoder, boolean onlineState) {
        logger.info("Creating the Host Application");
        if (hostId != null) {
            this.hostId = hostId;
            this.stateTopic = "spBv1.0/STATE/" + hostId;
        } else {
            this.hostId = null;
            this.stateTopic = null;
        }
        this.sparkplugSubscriptons = sparkplugSubscriptons;
        this.mqttServerDefinitions = mqttServerDefinitions;
        this.randomStartupDelay = randomStartupDelay;
        SequenceReorderManager sequenceReorderManager = SequenceReorderManager.getInstance();
        sequenceReorderManager.init(eventHandler, this, payloadDecoder, 5000L);
        this.tahuHostCallback = new TahuHostCallback(eventHandler, this, sequenceReorderManager, payloadDecoder, hostId, onlineState);
    }

    public HostApplication(MultiHostApplicationEventHandler eventHandler, String hostId, List<String> sparkplugSubscriptons, TahuHostCallback tahuHostCallback, Map<MqttServerName, TahuClient> tahuClients, RandomStartupDelay randomStartupDelay) {
        logger.info("Creating the Host Application");
        if (hostId != null && !hostId.trim().isEmpty()) {
            this.hostId = hostId;
            this.stateTopic = "spBv1.0/STATE/" + hostId;
        } else {
            this.hostId = null;
            this.stateTopic = null;
        }
        this.sparkplugSubscriptons = sparkplugSubscriptons;
        this.tahuHostCallback = tahuHostCallback;
        this.mqttServerDefinitions = null;
        this.tahuClients.putAll(tahuClients);
        this.randomStartupDelay = randomStartupDelay;
    }

    public void start(boolean onlineState) {
        if (this.mqttServerDefinitions != null) {
            for (MqttServerDefinition mqttServerDefinition : this.mqttServerDefinitions) {
                logger.debug("Starting up the MQTT Client to {}", (Object)mqttServerDefinition.getMqttServerName());
                TahuClient tahuClient = this.tahuClients.get(mqttServerDefinition.getMqttServerName());
                if (tahuClient == null) {
                    tahuClient = new TahuClient(mqttServerDefinition.getMqttClientId(), mqttServerDefinition.getMqttServerName(), mqttServerDefinition.getMqttServerUrl(), mqttServerDefinition.getUsername(), mqttServerDefinition.getPassword(), true, mqttServerDefinition.getKeepAliveTimeout(), this.tahuHostCallback, this.randomStartupDelay, onlineState, true, this.stateTopic, null, true, this.stateTopic, null, 1, true);
                }
                this.tahuClients.put(mqttServerDefinition.getMqttServerName(), tahuClient);
            }
        }
        for (TahuClient client : this.tahuClients.values()) {
            this.startClient(client);
        }
        logger.debug("MQTT Clients Started. Connection and subscriptions not verified yet");
    }

    private void startClient(TahuClient tahuClient) {
        tahuClient.setMaxInflightMessages(MAX_INFLIGHT_MESSAGES);
        this.tahuHostCallback.setMqttClients(this.tahuClients);
        try {
            tahuClient.setAutoReconnect(true);
            tahuClient.connect();
            if (this.stateTopic != null) {
                logger.debug("PrimaryHostId is set. Subscribing on {}", (Object)this.stateTopic);
                int grantedQos = tahuClient.subscribe(this.stateTopic, 1);
                if (grantedQos != 1) {
                    logger.error("Failed to subscribe to '{}'", (Object)this.stateTopic);
                    return;
                }
            }
            for (String subscriptionTopic : this.sparkplugSubscriptons) {
                logger.debug("Subscribing on {}", (Object)subscriptionTopic);
                int grantedQos = tahuClient.subscribe(subscriptionTopic, 0);
                if (grantedQos == 0) continue;
                logger.error("Failed to subscribe to '{}'", (Object)subscriptionTopic);
                return;
            }
        }
        catch (Exception e) {
            logger.error("Failed to start client {} connecting to {}", new Object[]{tahuClient.getClientId(), tahuClient.getMqttServerUrl(), e});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (TahuClient tahuClient : this.tahuClients.values()) {
            if (tahuClient != null) {
                String connectionId = tahuClient.getMqttServerUrl() + " :: " + tahuClient.getClientId();
                try {
                    if (this.stateTopic != null) {
                        logger.debug("Unsubscribing from {}", (Object)this.stateTopic);
                        tahuClient.unsubscribe(this.stateTopic);
                    }
                    for (String subscriptionTopic : this.sparkplugSubscriptons) {
                        logger.debug("Unsubscribing from {}", (Object)subscriptionTopic);
                        tahuClient.unsubscribe(subscriptionTopic);
                    }
                    this.tahuHostCallback.shutdown();
                    tahuClient.setAutoReconnect(false);
                    logger.info("Attempting disconnect {}", (Object)connectionId);
                    tahuClient.disconnect(100L, 100L, true, true);
                    logger.info("Successfully disconnected {}", (Object)connectionId);
                    continue;
                }
                catch (Exception e) {
                    logger.error("Error shutting down {}", (Object)connectionId, (Object)e);
                    continue;
                }
                finally {
                    tahuClient = null;
                    continue;
                }
            }
            logger.trace("Cannot shutdown null client");
        }
    }

    public void setOnlineState(boolean onlineState) {
        this.tahuHostCallback.setOnlineState(onlineState);
        for (TahuClient tahuClient : this.tahuClients.values()) {
            tahuClient.setOnlineState(onlineState);
        }
    }

    public String getHostId() {
        return this.hostId;
    }

    @Override
    public void publishCommand(Topic topic, SparkplugBPayload payload) throws Exception {
        for (MqttServerName mqttServerName : this.tahuClients.keySet()) {
            this.publishCommand(mqttServerName, topic, payload);
        }
    }

    @Override
    public void publishCommand(MqttServerName mqttServerName, Topic topic, SparkplugBPayload payload) throws Exception {
        TahuClient tahuClient = this.tahuClients.get(mqttServerName);
        if (tahuClient == null || !tahuClient.isConnected()) {
            throw new TahuException(TahuErrorCode.INITIALIZATION_ERROR, "The Tahu Client is not connected - not publishing command on topic=" + topic);
        }
        SparkplugBPayloadEncoder encoder = new SparkplugBPayloadEncoder();
        byte[] bytes = encoder.getBytes(payload, true);
        tahuClient.publish(topic.toString(), bytes, 0, false);
    }
}

