/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import org.eclipse.tahu.SparkplugParsingException;

public enum MessageType {
    NBIRTH,
    NDEATH,
    DBIRTH,
    DDEATH,
    NDATA,
    DDATA,
    NCMD,
    DCMD,
    STATE,
    DRECORD,
    NRECORD;


    public static MessageType parseMessageType(String type) throws SparkplugParsingException {
        for (MessageType messageType : MessageType.values()) {
            if (!messageType.name().equals(type)) continue;
            return messageType;
        }
        throw new SparkplugParsingException("Invalid message type: " + type);
    }

    public boolean isDeath() {
        return this.equals((Object)DDEATH) || this.equals((Object)NDEATH);
    }

    public boolean isCommand() {
        return this.equals((Object)DCMD) || this.equals((Object)NCMD);
    }

    public boolean isData() {
        return this.equals((Object)DDATA) || this.equals((Object)NDATA);
    }

    public boolean isBirth() {
        return this.equals((Object)DBIRTH) || this.equals((Object)NBIRTH);
    }

    public boolean isRecord() {
        return this.equals((Object)DRECORD) || this.equals((Object)NRECORD);
    }

    public boolean isEdgeNodeMessage() {
        return this.equals((Object)NBIRTH) || this.equals((Object)NDATA) || this.equals((Object)NCMD) || this.equals((Object)NDEATH) || this.equals((Object)NRECORD);
    }

    public boolean isDeviceMessage() {
        return this.equals((Object)DBIRTH) || this.equals((Object)DDATA) || this.equals((Object)DCMD) || this.equals((Object)DDEATH) || this.equals((Object)DRECORD);
    }
}

