/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonValue;
import org.eclipse.tahu.message.model.SparkplugDescriptor;

public class EdgeNodeDescriptor
implements SparkplugDescriptor {
    private final String groupId;
    private final String edgeNodeId;
    private final String descriptorString;

    public EdgeNodeDescriptor(String groupId, String edgeNodeId) {
        this.groupId = groupId;
        this.edgeNodeId = edgeNodeId;
        this.descriptorString = groupId + "/" + edgeNodeId;
    }

    public EdgeNodeDescriptor(String descriptorString) {
        String[] tokens = descriptorString.split("/");
        this.groupId = tokens[0];
        this.edgeNodeId = tokens[1];
        this.descriptorString = descriptorString;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getEdgeNodeId() {
        return this.edgeNodeId;
    }

    @Override
    public String getDeviceId() {
        return null;
    }

    @Override
    public boolean isDeviceDescriptor() {
        return false;
    }

    protected EdgeNodeDescriptor getEdgeNodeDescriptor() {
        return new EdgeNodeDescriptor(this.groupId, this.edgeNodeId);
    }

    @Override
    public String getDescriptorString() {
        return this.descriptorString;
    }

    public int hashCode() {
        return this.getDescriptorString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof EdgeNodeDescriptor) {
            return this.getDescriptorString().equals(((EdgeNodeDescriptor)object).getDescriptorString());
        }
        return this.getDescriptorString().equals(object);
    }

    @JsonValue
    public String toString() {
        return this.getDescriptorString();
    }
}

