/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.model.PropertyDataType;
import org.eclipse.tahu.message.model.PropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySet
implements Map<String, PropertyValue<? extends PropertyDataType>> {
    private static Logger logger = LoggerFactory.getLogger((String)PropertySet.class.getName());
    @JsonIgnore
    private Map<String, PropertyValue<? extends PropertyDataType>> map;

    public PropertySet() {
        this.map = new HashMap<String, PropertyValue<? extends PropertyDataType>>();
    }

    public PropertySet(PropertySet propertySet) throws Exception {
        this.map = new HashMap<String, PropertyValue<? extends PropertyDataType>>();
        if (propertySet.getPropertyMap() != null) {
            for (Map.Entry<String, PropertyValue<? extends PropertyDataType>> entry : propertySet.getPropertyMap().entrySet()) {
                this.map.put(entry.getKey(), new PropertyValue<PropertyDataType>(entry.getValue()));
            }
        }
        logger.trace("Copying - Orig: {}", (Object)propertySet);
        logger.trace("Copying - New : {}", (Object)this);
    }

    private PropertySet(Map<String, PropertyValue<? extends PropertyDataType>> propertyMap) {
        this.map = propertyMap;
    }

    @JsonIgnore
    public PropertyValue<? extends PropertyDataType> getPropertyValue(String name) {
        return this.map.get(name);
    }

    @JsonIgnore
    public void setProperty(String name, PropertyValue<? extends PropertyDataType> value) {
        this.map.put(name, value);
    }

    @JsonIgnore
    public void removeProperty(String name) {
        this.map.remove(name);
    }

    @Override
    @JsonIgnore
    public void clear() {
        this.map.clear();
    }

    @JsonIgnore
    public Set<String> getNames() {
        return this.map.keySet();
    }

    @JsonIgnore
    public Collection<PropertyValue<? extends PropertyDataType>> getValues() {
        return this.map.values();
    }

    @JsonIgnore
    public Map<String, PropertyValue<? extends PropertyDataType>> getPropertyMap() {
        return this.map;
    }

    public String toString() {
        return "PropertySet [propertyMap=" + this.map + "]";
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public PropertyValue<? extends PropertyDataType> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public PropertyValue<? extends PropertyDataType> put(String key, PropertyValue<? extends PropertyDataType> value) {
        return this.map.put(key, value);
    }

    @Override
    public PropertyValue<? extends PropertyDataType> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends PropertyValue<? extends PropertyDataType>> m) {
        this.map.putAll(m);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<PropertyValue<? extends PropertyDataType>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, PropertyValue<? extends PropertyDataType>>> entrySet() {
        return this.map.entrySet();
    }

    public static class PropertySetBuilder {
        private Map<String, PropertyValue<? extends PropertyDataType>> propertyMap;

        public PropertySetBuilder() {
            this.propertyMap = new HashMap<String, PropertyValue<? extends PropertyDataType>>();
        }

        public PropertySetBuilder(Map<String, PropertyValue<? extends PropertyDataType>> propertyMap) {
            this.propertyMap = propertyMap;
        }

        public PropertySetBuilder(PropertySet propertySet) throws SparkplugInvalidTypeException {
            this.propertyMap = new HashMap<String, PropertyValue<? extends PropertyDataType>>();
            for (String name : propertySet.getNames()) {
                PropertyValue<? extends PropertyDataType> value = propertySet.getPropertyValue(name);
                this.propertyMap.put(name, new PropertyValue<PropertyDataType>(value.getType(), value.getValue()));
            }
        }

        public PropertySetBuilder addProperty(String name, PropertyValue<? extends PropertyDataType> value) {
            this.propertyMap.put(name, value);
            return this;
        }

        public PropertySetBuilder addProperties(Map<String, PropertyValue<? extends PropertyDataType>> properties) {
            this.propertyMap.putAll(properties);
            return this;
        }

        public PropertySet createPropertySet() {
            return new PropertySet(this.propertyMap);
        }
    }
}

