/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host.model;

import org.eclipse.tahu.message.model.Message;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.Topic;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;

public class MessageContext {
    private final MqttServerName mqttServerName;
    private final MqttClientId hostAppMqttClientId;
    private final Message message;
    private final int payloadLength;
    private final long seqNum;

    public MessageContext(MqttServerName mqttServerName, MqttClientId hostAppMqttClientId, Topic topic, SparkplugBPayload payload, int payloadLength, long seqNum) {
        this.mqttServerName = mqttServerName;
        this.hostAppMqttClientId = hostAppMqttClientId;
        this.message = new Message.MessageBuilder(topic, payload).build();
        this.payloadLength = payloadLength;
        this.seqNum = seqNum;
    }

    public MqttServerName getMqttServerName() {
        return this.mqttServerName;
    }

    public MqttClientId getHostAppMqttClientId() {
        return this.hostAppMqttClientId;
    }

    public Message getMessage() {
        return this.message;
    }

    public Topic getTopic() {
        return this.message.getTopic();
    }

    public SparkplugBPayload getPayload() {
        return this.message.getPayload();
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public long getSeqNum() {
        return this.seqNum;
    }
}

