/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.mqtt;

import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;

public class RandomStartupDelay {
    public static final String ERROR_MESSAGE = "Random Startup Delay must be of the form 'min-max' where min is the low end of the range and max is the high end of the range in milliseconds";
    private final String randomStartupDelayString;
    private final long low;
    private final long high;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RandomStartupDelay(String randomStartupDelayString) throws TahuException {
        if (randomStartupDelayString != null && !randomStartupDelayString.trim().isEmpty()) {
            String[] pair = randomStartupDelayString.split("-");
            if (pair.length != 2) throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, ERROR_MESSAGE);
            try {
                this.low = Long.parseLong(pair[0].trim());
                this.high = Long.parseLong(pair[1].trim());
                if (this.low < 0L || this.high < 0L || this.high < this.low) {
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, ERROR_MESSAGE);
                }
                this.randomStartupDelayString = randomStartupDelayString;
                return;
            }
            catch (Exception e) {
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, ERROR_MESSAGE);
            }
        } else {
            this.randomStartupDelayString = null;
            this.low = -1L;
            this.high = -1L;
        }
    }

    public String getRandomStartupDelayString() {
        return this.randomStartupDelayString;
    }

    public long getLow() {
        return this.low;
    }

    public long getHigh() {
        return this.high;
    }

    public boolean isValid() {
        return this.low >= 0L && this.high >= this.low;
    }

    public long getRandomDelay() {
        if (this.randomStartupDelayString != null) {
            return this.low + (long)(Math.random() * (double)(this.high - this.low));
        }
        return 0L;
    }
}

