/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host.seq;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.eclipse.tahu.host.seq.SequenceReorderContext;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceReorderMap {
    private static Logger logger = LoggerFactory.getLogger((String)SequenceReorderMap.class.getName());
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final Map<Long, SequenceReorderContext> sequenceMap;
    private volatile long expectedSeqNum;
    private volatile Date lastUpdateTime;
    private final Object seqLock = new Object();

    public SequenceReorderMap(EdgeNodeDescriptor edgeNodeDescriptor) {
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.expectedSeqNum = 0L;
        this.lastUpdateTime = new Date();
        this.sequenceMap = new ConcurrentSkipListMap<Long, SequenceReorderContext>();
    }

    public EdgeNodeDescriptor getEdgeNodeDescriptor() {
        return this.edgeNodeDescriptor;
    }

    public long getNextExpectedSeqNum() {
        return this.expectedSeqNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean liveSeqNumCheck(long toMatch) {
        Object object = this.seqLock;
        synchronized (object) {
            boolean match = toMatch == this.expectedSeqNum;
            logger.trace("{} in liveSeqNumCheck - expected={} to actual={}", new Object[]{match ? "MATCHED" : "NOT MATCHED", this.expectedSeqNum, toMatch});
            if (match) {
                this.incrementExpectedSeqNum();
            }
            return match;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceReorderContext storedSeqNumCheck(long toMatch) {
        Object object = this.seqLock;
        synchronized (object) {
            SequenceReorderContext sequenceReorderContext = this.sequenceMap.remove(toMatch);
            if (sequenceReorderContext != null) {
                logger.trace("MATCHED in storedSeqNumCheck - Found stored message for {}", (Object)toMatch);
                this.incrementExpectedSeqNum();
            }
            return sequenceReorderContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSeqNum() {
        Object object = this.seqLock;
        synchronized (object) {
            this.expectedSeqNum = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementExpectedSeqNum() {
        Object object = this.seqLock;
        synchronized (object) {
            this.lastUpdateTime = new Date();
            ++this.expectedSeqNum;
            if (this.expectedSeqNum == 256L) {
                this.expectedSeqNum = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(long seqNum, SequenceReorderContext sequenceReorderContext) {
        Object object = this.seqLock;
        synchronized (object) {
            this.sequenceMap.put(seqNum, sequenceReorderContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(Date nBirthDate) {
        if (nBirthDate == null) {
            logger.error("Attempting to prune messages from the SequenceReorderMap failed. NBIRTH timestamp is null");
            return;
        }
        Object object = this.seqLock;
        synchronized (object) {
            logger.debug("Pruning with date {}", (Object)nBirthDate);
            Iterator<SequenceReorderContext> it = this.sequenceMap.values().iterator();
            while (it.hasNext()) {
                SequenceReorderContext sequenceReorderContext = it.next();
                if (sequenceReorderContext != null && sequenceReorderContext.getPayload() != null && sequenceReorderContext.getPayload().getTimestamp() != null && sequenceReorderContext.getPayload().getTimestamp().before(nBirthDate)) {
                    logger.debug("Removing old message {}", (Object)sequenceReorderContext.getTopic());
                    it.remove();
                    continue;
                }
                logger.debug("Checked {} - not removing because {} is after {}", new Object[]{sequenceReorderContext.getTopic(), sequenceReorderContext.getPayload().getTimestamp(), nBirthDate});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.seqLock;
        synchronized (object) {
            this.expectedSeqNum = 0L;
            this.lastUpdateTime = new Date();
            this.sequenceMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceReorderContext getExpiredSequenceReorderContext(long timeout) {
        Object object = this.seqLock;
        synchronized (object) {
            if (!this.sequenceMap.isEmpty()) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(14, (int)(timeout * -1L));
                if (this.lastUpdateTime.before(calendar.getTime())) {
                    return this.sequenceMap.values().iterator().next();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.seqLock;
        synchronized (object) {
            return this.sequenceMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.seqLock;
        synchronized (object) {
            return this.sequenceMap.isEmpty();
        }
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

