/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.json.DeserializerModifier;
import org.eclipse.tahu.json.DeserializerModule;
import org.eclipse.tahu.message.SparkplugBPayloadDecoder;
import org.eclipse.tahu.message.SparkplugBPayloadEncoder;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.model.MetricDataTypeMap;
import org.eclipse.tahu.util.CompressionAlgorithm;
import org.eclipse.tahu.util.GZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)PayloadUtil.class.getName());
    public static final String UUID_COMPRESSED = "SPBV1.0_COMPRESSED";
    public static final String METRIC_ALGORITHM = "algorithm";

    public static String toJsonString(SparkplugBPayload payload) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new DeserializerModule(new DeserializerModifier()));
        return mapper.writeValueAsString((Object)payload);
    }

    public static SparkplugBPayload fromJsonString(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new DeserializerModule(new DeserializerModifier()));
        return (SparkplugBPayload)mapper.readValue(jsonString, SparkplugBPayload.class);
    }

    public static SparkplugBPayload decompress(SparkplugBPayload payload, MetricDataTypeMap metricDataTypeMap) throws Exception {
        if (UUID_COMPRESSED.equals(payload.getUuid())) {
            logger.trace("Decompressing payload");
            SparkplugBPayloadDecoder decoder = new SparkplugBPayloadDecoder();
            CompressionConfig config = new CompressionConfig();
            List<Metric> metrics = payload.getMetrics();
            if (metrics != null && !metrics.isEmpty()) {
                for (Metric metric : metrics) {
                    if (!metric.getName().equals(METRIC_ALGORITHM)) continue;
                    config.setAlgorithm(CompressionAlgorithm.valueOf(metric.getValue().toString()));
                }
            }
            return decoder.buildFromByteArray(switch (config.getAlgorithm()) {
                case CompressionAlgorithm.GZIP -> GZipUtil.decompress(payload.getBody());
                case CompressionAlgorithm.DEFLATE -> PayloadUtil.inflateBytes(payload.getBody());
                default -> throw new SparkplugException("Unknown or unsupported algorithm " + config.getAlgorithm());
            }, metricDataTypeMap);
        }
        logger.trace("Not decompressing payload");
        return payload;
    }

    public static SparkplugBPayload compress(SparkplugBPayload payload, boolean stripDataTypes) throws IOException {
        logger.trace("Compressing payload");
        SparkplugBPayloadEncoder encoder = new SparkplugBPayloadEncoder();
        byte[] encoded = encoder.getBytes(payload, stripDataTypes);
        byte[] compressedBytes = PayloadUtil.deflateBytes(encoded);
        return new SparkplugBPayload.SparkplugBPayloadBuilder(payload.getSeq()).setBody(compressedBytes).setUuid(UUID_COMPRESSED).createPayload();
    }

    public static SparkplugBPayload compress(SparkplugBPayload payload, CompressionAlgorithm algorithm, boolean stripDataTypes) throws IOException, SparkplugException {
        logger.trace("Compressing payload");
        SparkplugBPayloadEncoder encoder = new SparkplugBPayloadEncoder();
        byte[] encoded = encoder.getBytes(payload, stripDataTypes);
        byte[] compressed = null;
        Metric algorithmMetric = new Metric.MetricBuilder(METRIC_ALGORITHM, MetricDataType.String, (Object)algorithm.toString()).createMetric();
        switch (algorithm) {
            case GZIP: {
                try {
                    compressed = GZipUtil.compress(encoded);
                    break;
                }
                catch (Exception e) {
                    logger.error("Failed to GZIP the payload");
                    throw new SparkplugException("Failed to GZIP the payload", e);
                }
            }
            case DEFLATE: {
                compressed = PayloadUtil.deflateBytes(encoded);
                break;
            }
            default: {
                throw new SparkplugException("Unknown or unsupported algorithm " + algorithm);
            }
        }
        return new SparkplugBPayload.SparkplugBPayloadBuilder(payload.getSeq()).setBody(compressed).setUuid(UUID_COMPRESSED).addMetric(algorithmMetric).createPayload();
    }

    protected static byte[] deflateBytes(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        Deflater deflater = new Deflater();
        deflater.setInput(bytes);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            baos.write(buffer, 0, count);
        }
        baos.close();
        return baos.toByteArray();
    }

    protected static byte[] inflateBytes(byte[] bytes) throws IOException, DataFormatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        Inflater inflater = new Inflater();
        inflater.setInput(bytes);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            baos.write(buffer, 0, count);
        }
        baos.close();
        return baos.toByteArray();
    }

    protected static class CompressionConfig {
        private CompressionAlgorithm algorithm = CompressionAlgorithm.DEFLATE;

        public CompressionAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(CompressionAlgorithm algorithm) {
            this.algorithm = algorithm;
        }
    }
}

