/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Template {
    private static Logger logger = LoggerFactory.getLogger((String)Template.class.getName());
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="reference")
    private String templateRef;
    @JsonProperty(value="isDefinition")
    private boolean isDefinition;
    @JsonProperty(value="metrics")
    private List<Metric> metrics;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Parameter> parameters;

    public Template() {
    }

    public Template(String version, String templateRef, boolean isDefinition, List<Metric> metrics, List<Parameter> parameters) {
        this.version = version;
        this.templateRef = templateRef;
        this.isDefinition = isDefinition;
        this.metrics = metrics;
        this.parameters = parameters;
    }

    public Template(Template template) throws Exception {
        this.version = template.getVersion();
        this.templateRef = template.getTemplateRef();
        this.isDefinition = template.isDefinition();
        if (template.getMetrics() != null) {
            this.metrics = new ArrayList<Metric>();
            for (Metric metric : template.getMetrics()) {
                this.metrics.add(new Metric(metric));
            }
        }
        if (template.getParameters() != null) {
            this.parameters = new ArrayList<Parameter>();
            for (Parameter parameter : template.getParameters()) {
                this.parameters.add(new Parameter(parameter));
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTemplateRef() {
        return this.templateRef;
    }

    public void setTemplateRef(String templateRef) {
        this.templateRef = templateRef;
    }

    @JsonGetter(value="isDefinition")
    public boolean isDefinition() {
        return this.isDefinition;
    }

    @JsonSetter(value="isDefinition")
    public void setDefinition(boolean isDefinition) {
        this.isDefinition = isDefinition;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Template [version=");
        builder.append(this.version);
        builder.append(", templateRef=");
        builder.append(this.templateRef);
        builder.append(", isDefinition=");
        builder.append(this.isDefinition);
        builder.append(", metrics=");
        builder.append(this.metrics);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append("]");
        return builder.toString();
    }

    public static class TemplateBuilder {
        private String version;
        private String templateRef;
        private boolean isDefinition;
        private List<Metric> metrics;
        private List<Parameter> parameters;

        public TemplateBuilder() {
            this.metrics = new ArrayList<Metric>();
            this.parameters = new ArrayList<Parameter>();
        }

        public TemplateBuilder(Template template) throws SparkplugException {
            this.version = template.getVersion();
            this.templateRef = template.getTemplateRef();
            this.isDefinition = template.isDefinition();
            this.metrics = new ArrayList<Metric>(template.getMetrics().size());
            for (Metric metric : template.getMetrics()) {
                this.metrics.add(new Metric.MetricBuilder(metric).createMetric());
            }
            this.parameters = new ArrayList<Parameter>(template.getParameters().size());
            for (Parameter parameter : template.getParameters()) {
                this.parameters.add(new Parameter(parameter.getName(), parameter.getType(), parameter.getValue()));
            }
        }

        public TemplateBuilder version(String version) {
            this.version = version;
            return this;
        }

        public TemplateBuilder templateRef(String templateRef) {
            this.templateRef = templateRef;
            return this;
        }

        public TemplateBuilder definition(boolean isDefinition) {
            this.isDefinition = isDefinition;
            return this;
        }

        public TemplateBuilder addMetric(Metric metric) {
            this.metrics.add(metric);
            return this;
        }

        public TemplateBuilder addMetrics(Collection<Metric> metrics) {
            this.metrics.addAll(metrics);
            return this;
        }

        public TemplateBuilder addParameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public TemplateBuilder addParameters(Collection<Parameter> parameters) {
            this.parameters.addAll(parameters);
            return this;
        }

        public Template createTemplate() {
            return new Template(this.version, this.templateRef, this.isDefinition, this.metrics, this.parameters);
        }
    }
}

