/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.model.PropertyDataType;
import org.eclipse.tahu.message.model.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyValue<T extends PropertyDataType> {
    private static Logger logger = LoggerFactory.getLogger((String)PropertyValue.class.getName());
    private T type;
    private Object value;
    private Boolean isNull = null;

    public PropertyValue() {
    }

    public PropertyValue(T type, Object value) throws SparkplugInvalidTypeException {
        this.type = type;
        this.value = value;
        this.isNull = value == null;
        ((PropertyDataType)type).checkType(value);
    }

    public PropertyValue(PropertyValue<T> propertyValue) throws Exception {
        if (propertyValue == null) {
            return;
        }
        this.type = propertyValue.getType();
        this.isNull = propertyValue.isNull();
        if (!this.isNull.booleanValue()) {
            if (this.type == PropertyDataType.DateTime) {
                this.value = new Date(((Date)propertyValue.getValue()).getTime());
            } else if (this.type == PropertyDataType.PropertySet) {
                this.value = new PropertySet((PropertySet)propertyValue.getValue());
            } else if (this.type == PropertyDataType.PropertySetList) {
                List originalPropertySetList = (List)propertyValue.getValue();
                ArrayList<PropertySet> newPropertySetList = new ArrayList<PropertySet>();
                for (PropertySet propertySet : originalPropertySetList) {
                    newPropertySetList.add(new PropertySet(propertySet));
                }
                this.value = newPropertySetList;
            } else {
                this.value = propertyValue.getValue();
            }
        }
        ((PropertyDataType)this.type).checkType(this.value);
        logger.trace("Copying - Orig: {}", propertyValue);
        logger.trace("copying - New : {}", (Object)this);
    }

    public T getType() {
        return this.type;
    }

    public void setType(T type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.isNull = value == null;
    }

    @JsonIgnore
    public Boolean isNull() {
        return this.isNull;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PropertyValue propValue = (PropertyValue)object;
        return Objects.equals(this.type, propValue.getType()) && Objects.equals(this.value, propValue.getValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PropertyValue [type=");
        builder.append(this.type);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", isNull=");
        builder.append(this.isNull);
        builder.append("]");
        return builder.toString();
    }
}

