/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.message.model.DataSet;
import org.eclipse.tahu.message.model.File;
import org.eclipse.tahu.message.model.MetaData;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.PropertySet;
import org.eclipse.tahu.message.model.Template;
import org.eclipse.tahu.message.model.TemplateMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"isNull"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Metric {
    private static Logger logger = LoggerFactory.getLogger((String)Metric.class.getName());
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="alias")
    private Long alias;
    @JsonProperty(value="timestamp")
    private Date timestamp;
    @JsonProperty(value="dataType")
    private MetricDataType dataType;
    @JsonProperty(value="isHistorical")
    private Boolean isHistorical;
    @JsonProperty(value="isTransient")
    private Boolean isTransient;
    @JsonProperty(value="metaData")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private MetaData metaData;
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private PropertySet properties;
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Object value;
    private Boolean isNull = null;

    public Metric() {
    }

    public Metric(String name, Long alias, Date timestamp, MetricDataType dataType, Boolean isHistorical, Boolean isTransient, MetaData metaData, PropertySet properties, Object value) throws SparkplugInvalidTypeException {
        this.name = name;
        this.alias = alias;
        this.timestamp = timestamp;
        this.dataType = dataType;
        this.isHistorical = isHistorical;
        this.isTransient = isTransient;
        this.isNull = value == null;
        this.metaData = metaData;
        this.properties = properties;
        this.value = value;
        this.dataType.checkType(value);
    }

    public Metric(Metric metric) throws Exception {
        if (metric != null) {
            this.name = metric.getName();
            this.alias = metric.getAlias();
            this.timestamp = metric.getTimestamp();
            this.dataType = metric.getDataType();
            this.isHistorical = metric.getIsHistorical();
            this.isTransient = metric.getIsTransient();
            this.metaData = metric.getMetaData() != null ? new MetaData(metric.getMetaData()) : null;
            PropertySet propertySet = this.properties = metric.getProperties() != null ? new PropertySet(metric.getProperties()) : null;
            if (metric.getValue() != null) {
                if (metric.getDataType() == MetricDataType.DataSet) {
                    this.value = new DataSet((DataSet)metric.getValue());
                } else if (metric.getDataType() == MetricDataType.Bytes) {
                    byte[] originalValue = (byte[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.File) {
                    this.value = new File((File)metric.getValue());
                } else if (metric.getDataType() == MetricDataType.Int8Array) {
                    Byte[] originalValue = (Byte[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.Int16Array) {
                    Short[] originalValue = (Short[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.Int32Array) {
                    Integer[] originalValue = (Integer[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.Int64Array) {
                    Long[] originalValue = (Long[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.UInt8Array) {
                    Short[] originalValue = (Short[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.UInt16Array) {
                    Integer[] originalValue = (Integer[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.UInt32Array) {
                    Long[] originalValue = (Long[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.UInt64Array) {
                    BigInteger[] originalValue = (BigInteger[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.FloatArray) {
                    Float[] originalValue = (Float[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.DoubleArray) {
                    Double[] originalValue = (Double[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.BooleanArray) {
                    Boolean[] originalValue = (Boolean[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.StringArray) {
                    String[] originalValue = (String[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else if (metric.getDataType() == MetricDataType.DateTimeArray) {
                    Date[] originalValue = (Date[])metric.getValue();
                    this.value = Arrays.copyOf(originalValue, originalValue.length);
                } else {
                    this.value = metric.getDataType() == MetricDataType.Template ? new Template((Template)metric.getValue()) : metric.getValue();
                }
            }
            this.dataType.checkType(this.value);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    @JsonIgnore
    public String getKey() throws Exception {
        String primaryKeyComponent;
        String string = this.hasName() ? this.getName() : (primaryKeyComponent = this.hasAlias() ? this.getAlias().toString() : null);
        if (this.dataType == MetricDataType.Template) {
            String key = this.getTimestamp().getTime() + "_" + this.getSecondaryKeyComponent(primaryKeyComponent, this);
            logger.debug("Returning template key: {}", (Object)key);
            return key;
        }
        if (primaryKeyComponent != null) {
            String key = this.getTimestamp().getTime() + "_" + primaryKeyComponent;
            logger.debug("Returning regular key: {}", (Object)key);
            return key;
        }
        return null;
    }

    private String getSecondaryKeyComponent(String prefix, Metric metric) throws Exception {
        if (this.dataType == MetricDataType.Template) {
            if (metric.getValue() != null) {
                if (Template.class.isAssignableFrom(metric.getValue().getClass())) {
                    Template template = (Template)metric.getValue();
                    if (template.getMetrics() != null && template.getMetrics().size() == 1) {
                        String secondaryName;
                        Metric memberMetric = template.getMetrics().get(0);
                        String string = memberMetric.hasName() ? memberMetric.getName() : (secondaryName = memberMetric.hasAlias() ? memberMetric.getAlias().toString() : null);
                        if (secondaryName != null) {
                            if (memberMetric.getDataType() == MetricDataType.Template) {
                                return this.getSecondaryKeyComponent(prefix + "_" + secondaryName, memberMetric);
                            }
                            return prefix + "_" + secondaryName;
                        }
                        throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Template Metric has an invalid config " + metric);
                    }
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Template Metrics must only have a single member Metric " + metric);
                }
                if (TemplateMap.class.isAssignableFrom(metric.getValue().getClass())) {
                    TemplateMap templateMap = (TemplateMap)metric.getValue();
                    if (templateMap.getMetrics() != null && templateMap.getMetrics().size() == 1) {
                        String secondaryName;
                        Metric memberMetric = templateMap.getMetrics().get(0);
                        String string = memberMetric.hasName() ? memberMetric.getName() : (secondaryName = memberMetric.hasAlias() ? memberMetric.getAlias().toString() : null);
                        if (secondaryName != null) {
                            if (memberMetric.getDataType() == MetricDataType.Template) {
                                return this.getSecondaryKeyComponent(prefix + "_" + secondaryName, memberMetric);
                            }
                            return prefix + "_" + secondaryName;
                        }
                        throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Template Metric has an invalid config " + metric);
                    }
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "TemplateMap Metrics must only have a single member Metric " + metric);
                }
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Invalid Template MetricDataType " + metric);
            }
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "Template Metrics must only have one member Metric " + metric);
        }
        return prefix;
    }

    public boolean hasAlias() {
        return this.alias != null;
    }

    public Long getAlias() {
        return this.alias;
    }

    public void setAlias(long alias) {
        this.alias = alias;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public MetricDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(MetricDataType dataType) {
        this.dataType = dataType;
    }

    @JsonGetter(value="metaData")
    public MetaData getMetaData() {
        return this.metaData;
    }

    @JsonSetter(value="metaData")
    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.isNull = value == null;
    }

    public PropertySet getProperties() {
        return this.properties;
    }

    public void setProperties(PropertySet properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public Boolean isHistorical() {
        return this.isHistorical == null ? false : this.isHistorical;
    }

    @JsonGetter(value="isHistorical")
    public Boolean getIsHistorical() {
        return this.isHistorical;
    }

    @JsonSetter(value="isHistorical")
    public void setHistorical(Boolean isHistorical) {
        this.isHistorical = isHistorical;
    }

    @JsonIgnore
    public Boolean isTransient() {
        return this.isTransient == null ? false : this.isTransient;
    }

    @JsonGetter(value="isTransient")
    public Boolean getIsTransient() {
        return this.isTransient;
    }

    @JsonSetter(value="isTransient")
    public void setTransient(Boolean isTransient) {
        this.isTransient = isTransient;
    }

    @JsonIgnore
    public Boolean isNull() {
        return this.isNull == null ? false : this.isNull;
    }

    @JsonIgnore
    public Boolean getIsNull() {
        return this.isNull;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.isHistorical == null ? 0 : this.isHistorical.hashCode());
        result = 31 * result + (this.isNull == null ? 0 : this.isNull.hashCode());
        result = 31 * result + (this.isTransient == null ? 0 : this.isTransient.hashCode());
        result = 31 * result + (this.metaData == null ? 0 : this.metaData.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metric other = (Metric)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.dataType != other.dataType) {
            return false;
        }
        if (this.isHistorical == null ? other.isHistorical != null : !this.isHistorical.equals(other.isHistorical)) {
            return false;
        }
        if (this.isNull == null ? other.isNull != null : !this.isNull.equals(other.isNull)) {
            return false;
        }
        if (this.isTransient == null ? other.isTransient != null : !this.isTransient.equals(other.isTransient)) {
            return false;
        }
        if (this.metaData == null ? other.metaData != null : !this.metaData.equals(other.metaData)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Metric [name=");
        builder.append(this.name);
        builder.append(", alias=");
        builder.append(this.alias);
        builder.append(", timestamp=");
        builder.append(this.timestamp != null ? Long.valueOf(this.timestamp.getTime()) : "null");
        builder.append(", dataType=");
        builder.append(this.dataType);
        builder.append(", isHistorical=");
        builder.append(this.isHistorical);
        builder.append(", isTransient=");
        builder.append(this.isTransient);
        builder.append(", metaData=");
        builder.append(this.metaData);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", value=");
        if (this.dataType == MetricDataType.BooleanArray) {
            builder.append(Arrays.toString((Object[])((Boolean[])this.value)));
        } else if (this.dataType == MetricDataType.DateTimeArray) {
            builder.append(Arrays.toString((Date[])this.value));
        } else if (this.dataType == MetricDataType.DoubleArray) {
            builder.append(Arrays.toString((Object[])((Double[])this.value)));
        } else if (this.dataType == MetricDataType.FloatArray) {
            builder.append(Arrays.toString((Object[])((Float[])this.value)));
        } else if (this.dataType == MetricDataType.Int8Array) {
            builder.append(Arrays.toString((Object[])((Byte[])this.value)));
        } else if (this.dataType == MetricDataType.Int16Array) {
            builder.append(Arrays.toString((Object[])((Short[])this.value)));
        } else if (this.dataType == MetricDataType.Int32Array) {
            builder.append(Arrays.toString((Object[])((Integer[])this.value)));
        } else if (this.dataType == MetricDataType.Int64Array) {
            builder.append(Arrays.toString((Object[])((Long[])this.value)));
        } else if (this.dataType == MetricDataType.StringArray) {
            builder.append(Arrays.toString((String[])this.value));
        } else if (this.dataType == MetricDataType.UInt8Array) {
            builder.append(Arrays.toString((Object[])((Short[])this.value)));
        } else if (this.dataType == MetricDataType.UInt16Array) {
            builder.append(Arrays.toString((Object[])((Integer[])this.value)));
        } else if (this.dataType == MetricDataType.UInt32Array) {
            builder.append(Arrays.toString((Object[])((Long[])this.value)));
        } else if (this.dataType == MetricDataType.UInt64Array) {
            builder.append(Arrays.toString((BigInteger[])this.value));
        } else {
            builder.append(this.value);
        }
        builder.append(", isNull=");
        builder.append(this.isNull);
        builder.append("]");
        return builder.toString();
    }

    public static class MetricBuilder {
        private String name;
        private Long alias;
        private Date timestamp;
        private MetricDataType dataType;
        private Boolean isHistorical;
        private Boolean isTransient;
        private MetaData metaData = null;
        private PropertySet properties = null;
        private Object value;

        public MetricBuilder(String name, MetricDataType dataType, Object value) {
            this.name = name;
            this.timestamp = new Date();
            this.dataType = dataType;
            this.value = value;
        }

        public MetricBuilder(Long alias, MetricDataType dataType, Object value) {
            this.alias = alias;
            this.timestamp = new Date();
            this.dataType = dataType;
            this.value = value;
        }

        public MetricBuilder(Metric metric) throws SparkplugException {
            this.name = metric.getName();
            this.alias = metric.getAlias();
            this.timestamp = metric.getTimestamp();
            this.dataType = metric.getDataType();
            this.isHistorical = metric.isHistorical();
            this.isTransient = metric.isTransient();
            this.metaData = metric.getMetaData() != null ? new MetaData.MetaDataBuilder(metric.getMetaData()).createMetaData() : null;
            PropertySet propertySet = this.properties = metric.getMetaData() != null ? new PropertySet.PropertySetBuilder(metric.getProperties()).createPropertySet() : null;
            this.value = this.dataType.toIntValue() == MetricDataType.DataSet.toIntValue() ? (metric.getValue() != null ? new DataSet.DataSetBuilder((DataSet)metric.getValue()).createDataSet() : null) : (this.dataType.toIntValue() == MetricDataType.Template.toIntValue() ? (metric.getValue() != null ? new Template.TemplateBuilder((Template)metric.getValue()).createTemplate() : null) : metric.getValue());
        }

        public MetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricBuilder alias(Long alias) {
            this.alias = alias;
            return this;
        }

        public MetricBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public MetricBuilder dataType(MetricDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public MetricBuilder isHistorical(Boolean isHistorical) {
            this.isHistorical = isHistorical;
            return this;
        }

        public MetricBuilder isTransient(Boolean isTransient) {
            this.isTransient = isTransient;
            return this;
        }

        public MetricBuilder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public MetricBuilder properties(PropertySet properties) {
            this.properties = properties;
            return this;
        }

        public MetricBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public Metric createMetric() throws SparkplugInvalidTypeException {
            return new Metric(this.name, this.alias, this.timestamp, this.dataType, this.isHistorical, this.isTransient, this.metaData, this.properties, this.value);
        }
    }
}

