/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.Topic;

public class Message {
    private Topic topic;
    private SparkplugBPayload payload;

    public Message() {
    }

    public Message(Message message) {
        this.topic = message.getTopic();
        this.payload = new SparkplugBPayload(message.getPayload());
    }

    private Message(Topic topic, SparkplugBPayload payload) {
        this.topic = topic;
        this.payload = payload;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public SparkplugBPayload getPayload() {
        return this.payload;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Message [topic=");
        builder.append(this.topic);
        builder.append(", payload=");
        builder.append(this.payload);
        builder.append("]");
        return builder.toString();
    }

    public static class MessageBuilder {
        private Topic topic;
        private SparkplugBPayload payload;

        public MessageBuilder(Topic topic, SparkplugBPayload payload) {
            this.topic = topic;
            this.payload = payload;
        }

        public MessageBuilder() {
        }

        public MessageBuilder topic(Topic topic) {
            this.topic = topic;
            return this;
        }

        public MessageBuilder payload(SparkplugBPayload payload) {
            this.payload = payload;
            return this;
        }

        public Message build() {
            return new Message(this.topic, this.payload);
        }
    }
}

