/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.message.model.MetricDataType;

public class MetricDataTypeMap {
    private final Map<String, MetricDataType> nameDataTypeMap = new ConcurrentHashMap<String, MetricDataType>();
    private final Map<Long, MetricDataType> aliasDataTypeMap = new ConcurrentHashMap<Long, MetricDataType>();

    public void addMetricDataType(String metricName, MetricDataType metricDataType) {
        this.nameDataTypeMap.put(metricName, metricDataType);
    }

    public void addMetricDataType(Long alias, MetricDataType metricDataType) {
        this.aliasDataTypeMap.put(alias, metricDataType);
    }

    public MetricDataType getMetricDataType(String metricName) {
        return this.nameDataTypeMap.get(metricName);
    }

    public MetricDataType getMetricDataType(Long alias) {
        return this.aliasDataTypeMap.get(alias);
    }

    public boolean isEmpty() {
        return this.nameDataTypeMap.isEmpty() && this.aliasDataTypeMap.isEmpty();
    }

    public void clear() {
        this.nameDataTypeMap.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetricDataTypeMap [nameDataTypeMap=");
        builder.append(this.nameDataTypeMap);
        builder.append(", aliasDataTypeMap=");
        builder.append(this.aliasDataTypeMap);
        builder.append("]");
        return builder.toString();
    }
}

