/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import java.util.Date;
import org.eclipse.tahu.message.model.DataSetDataType;

public class Value<V> {
    private DataSetDataType type;
    private V value;

    public Value() {
    }

    public Value(DataSetDataType type, V value) {
        this.type = type;
        this.value = value;
    }

    public Value(Value<V> originalValue) {
        this.type = originalValue.getType();
        if (this.type == DataSetDataType.DateTime) {
            if (originalValue.getValue() != null) {
                Date date = new Date(((Date)originalValue.getValue()).getTime());
                this.value = date;
            } else {
                this.value = null;
            }
        } else {
            this.value = originalValue.getValue() != null ? originalValue.getValue() : null;
        }
    }

    public DataSetDataType getType() {
        return this.type;
    }

    public void setType(DataSetDataType type) {
        this.type = type;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Value [type=");
        builder.append(this.type);
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }
}

