/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import org.eclipse.tahu.message.model.EdgeNodeDescriptor;

public class DeviceDescriptor
extends EdgeNodeDescriptor {
    private final String deviceId;
    private final String descriptorString;

    public DeviceDescriptor(String groupId, String edgeNodeId, String deviceId) {
        super(groupId, edgeNodeId);
        this.deviceId = deviceId;
        this.descriptorString = groupId + "/" + edgeNodeId + "/" + deviceId;
    }

    public DeviceDescriptor(String descriptorString) {
        super(descriptorString.substring(0, descriptorString.lastIndexOf("/")));
        this.deviceId = descriptorString.substring(descriptorString.lastIndexOf("/") + 1);
        this.descriptorString = descriptorString;
    }

    public DeviceDescriptor(EdgeNodeDescriptor edgeNodeDescriptor, String deviceId) {
        super(edgeNodeDescriptor.getGroupId(), edgeNodeDescriptor.getEdgeNodeId());
        this.deviceId = deviceId;
        this.descriptorString = edgeNodeDescriptor.getDescriptorString() + "/" + deviceId;
    }

    @Override
    public boolean isDeviceDescriptor() {
        return true;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getDescriptorString() {
        return this.descriptorString;
    }

    @Override
    public EdgeNodeDescriptor getEdgeNodeDescriptor() {
        return super.getEdgeNodeDescriptor();
    }

    public String getEdgeNodeDescriptorString() {
        return super.getDescriptorString();
    }

    @Override
    public int hashCode() {
        return this.getDescriptorString().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DeviceDescriptor) {
            return this.getDescriptorString().equals(((DeviceDescriptor)object).getDescriptorString());
        }
        return this.getDescriptorString().equals(object);
    }

    @Override
    public String toString() {
        return this.getDescriptorString();
    }
}

