/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tahu.SparkplugParsingException;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Topic;

public class TopicUtil {
    private static final Map<String, String[]> SPLIT_TOPIC_CACHE = new HashMap<String, String[]>();

    public static String[] getSplitTopic(String topic) {
        String[] splitTopic = SPLIT_TOPIC_CACHE.get(topic);
        if (splitTopic == null) {
            splitTopic = topic.split("/");
            SPLIT_TOPIC_CACHE.put(topic, splitTopic);
        }
        return splitTopic;
    }

    public static String toJsonString(Topic topic) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)topic);
    }

    public static Topic parseTopic(String topic) throws SparkplugParsingException {
        return TopicUtil.parseTopic(TopicUtil.getSplitTopic(topic));
    }

    public static Topic parseTopic(String[] splitTopic) throws SparkplugParsingException {
        int length = splitTopic.length;
        if (length == 3 && MessageType.STATE.toString().equals(splitTopic[1])) {
            return new Topic(splitTopic[0], splitTopic[2], MessageType.STATE);
        }
        if (length < 4 || length > 5) {
            throw new SparkplugParsingException("Invalid number of topic elements: " + length);
        }
        String namespace = splitTopic[0];
        String groupId = splitTopic[1];
        MessageType type = MessageType.parseMessageType(splitTopic[2]);
        String edgeNodeId = splitTopic[3];
        if (length == 4) {
            switch (type) {
                case NBIRTH: 
                case NCMD: 
                case NDATA: 
                case NDEATH: 
                case NRECORD: {
                    return new Topic(namespace, groupId, edgeNodeId, type);
                }
            }
        } else {
            switch (type) {
                case DBIRTH: 
                case DCMD: 
                case DDATA: 
                case DDEATH: 
                case DRECORD: {
                    return new Topic(namespace, groupId, edgeNodeId, splitTopic[4], type);
                }
            }
        }
        throw new SparkplugParsingException("Invalid number of topic elements " + length + " for topic type " + (Object)((Object)type));
    }
}

